// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.imagebuilder.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the
 * creation, management, and deployment of customized, secure, and up-to-date "golden" server
 * images that are pre-installed and pre-configured with software and settings to meet specific
 * IT standards.
 */
interface ImagebuilderClient : SdkClient {

    override val serviceName: String
        get() = "imagebuilder"
    /**
     * ImagebuilderClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): ImagebuilderClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultImagebuilderClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, IdempotencyTokenConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * CancelImageCreation cancels the creation of Image. This operation can only be used on
     * images in a non-terminal state.
     */
    suspend fun cancelImageCreation(input: CancelImageCreationRequest): CancelImageCreationResponse

    /**
     * CancelImageCreation cancels the creation of Image. This operation can only be used on
     * images in a non-terminal state.
     */
    suspend fun cancelImageCreation(block: CancelImageCreationRequest.DslBuilder.() -> Unit) = cancelImageCreation(CancelImageCreationRequest.builder().apply(block).build())

    /**
     * Creates a new component that can be used to build, validate, test, and assess your
     * image.
     */
    suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a new component that can be used to build, validate, test, and assess your
     * image.
     */
    suspend fun createComponent(block: CreateComponentRequest.DslBuilder.() -> Unit) = createComponent(CreateComponentRequest.builder().apply(block).build())

    /**
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     */
    suspend fun createContainerRecipe(input: CreateContainerRecipeRequest): CreateContainerRecipeResponse

    /**
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     */
    suspend fun createContainerRecipe(block: CreateContainerRecipeRequest.DslBuilder.() -> Unit) = createContainerRecipe(CreateContainerRecipeRequest.builder().apply(block).build())

    /**
     * Creates a new distribution configuration. Distribution configurations define and configure
     * the outputs of your pipeline.
     */
    suspend fun createDistributionConfiguration(input: CreateDistributionConfigurationRequest): CreateDistributionConfigurationResponse

    /**
     * Creates a new distribution configuration. Distribution configurations define and configure
     * the outputs of your pipeline.
     */
    suspend fun createDistributionConfiguration(block: CreateDistributionConfigurationRequest.DslBuilder.() -> Unit) = createDistributionConfiguration(CreateDistributionConfigurationRequest.builder().apply(block).build())

    /**
     * Creates a new image. This request will create a new image along with all of the
     * configured output resources defined in the distribution configuration. You must specify
     * exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
     */
    suspend fun createImage(input: CreateImageRequest): CreateImageResponse

    /**
     * Creates a new image. This request will create a new image along with all of the
     * configured output resources defined in the distribution configuration. You must specify
     * exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.
     */
    suspend fun createImage(block: CreateImageRequest.DslBuilder.() -> Unit) = createImage(CreateImageRequest.builder().apply(block).build())

    /**
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and
     * distribution of images.
     */
    suspend fun createImagePipeline(input: CreateImagePipelineRequest): CreateImagePipelineResponse

    /**
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and
     * distribution of images.
     */
    suspend fun createImagePipeline(block: CreateImagePipelineRequest.DslBuilder.() -> Unit) = createImagePipeline(CreateImagePipelineRequest.builder().apply(block).build())

    /**
     * Creates a new image recipe. Image recipes define how images are configured, tested, and
     * assessed.
     */
    suspend fun createImageRecipe(input: CreateImageRecipeRequest): CreateImageRecipeResponse

    /**
     * Creates a new image recipe. Image recipes define how images are configured, tested, and
     * assessed.
     */
    suspend fun createImageRecipe(block: CreateImageRecipeRequest.DslBuilder.() -> Unit) = createImageRecipe(CreateImageRecipeRequest.builder().apply(block).build())

    /**
     * Creates a new infrastructure configuration. An infrastructure configuration defines the
     * environment in which your image will be built and tested.
     */
    suspend fun createInfrastructureConfiguration(input: CreateInfrastructureConfigurationRequest): CreateInfrastructureConfigurationResponse

    /**
     * Creates a new infrastructure configuration. An infrastructure configuration defines the
     * environment in which your image will be built and tested.
     */
    suspend fun createInfrastructureConfiguration(block: CreateInfrastructureConfigurationRequest.DslBuilder.() -> Unit) = createInfrastructureConfiguration(CreateInfrastructureConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes a component build version.
     */
    suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a component build version.
     */
    suspend fun deleteComponent(block: DeleteComponentRequest.DslBuilder.() -> Unit) = deleteComponent(DeleteComponentRequest.builder().apply(block).build())

    /**
     * Deletes a container recipe.
     */
    suspend fun deleteContainerRecipe(input: DeleteContainerRecipeRequest): DeleteContainerRecipeResponse

    /**
     * Deletes a container recipe.
     */
    suspend fun deleteContainerRecipe(block: DeleteContainerRecipeRequest.DslBuilder.() -> Unit) = deleteContainerRecipe(DeleteContainerRecipeRequest.builder().apply(block).build())

    /**
     * Deletes a distribution configuration.
     */
    suspend fun deleteDistributionConfiguration(input: DeleteDistributionConfigurationRequest): DeleteDistributionConfigurationResponse

    /**
     * Deletes a distribution configuration.
     */
    suspend fun deleteDistributionConfiguration(block: DeleteDistributionConfigurationRequest.DslBuilder.() -> Unit) = deleteDistributionConfiguration(DeleteDistributionConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes an image.
     */
    suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse

    /**
     * Deletes an image.
     */
    suspend fun deleteImage(block: DeleteImageRequest.DslBuilder.() -> Unit) = deleteImage(DeleteImageRequest.builder().apply(block).build())

    /**
     * Deletes an image pipeline.
     */
    suspend fun deleteImagePipeline(input: DeleteImagePipelineRequest): DeleteImagePipelineResponse

    /**
     * Deletes an image pipeline.
     */
    suspend fun deleteImagePipeline(block: DeleteImagePipelineRequest.DslBuilder.() -> Unit) = deleteImagePipeline(DeleteImagePipelineRequest.builder().apply(block).build())

    /**
     * Deletes an image recipe.
     */
    suspend fun deleteImageRecipe(input: DeleteImageRecipeRequest): DeleteImageRecipeResponse

    /**
     * Deletes an image recipe.
     */
    suspend fun deleteImageRecipe(block: DeleteImageRecipeRequest.DslBuilder.() -> Unit) = deleteImageRecipe(DeleteImageRecipeRequest.builder().apply(block).build())

    /**
     * Deletes an infrastructure configuration.
     */
    suspend fun deleteInfrastructureConfiguration(input: DeleteInfrastructureConfigurationRequest): DeleteInfrastructureConfigurationResponse

    /**
     * Deletes an infrastructure configuration.
     */
    suspend fun deleteInfrastructureConfiguration(block: DeleteInfrastructureConfigurationRequest.DslBuilder.() -> Unit) = deleteInfrastructureConfiguration(DeleteInfrastructureConfigurationRequest.builder().apply(block).build())

    /**
     * Gets a component object.
     */
    suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Gets a component object.
     */
    suspend fun getComponent(block: GetComponentRequest.DslBuilder.() -> Unit) = getComponent(GetComponentRequest.builder().apply(block).build())

    /**
     * Gets a component policy.
     */
    suspend fun getComponentPolicy(input: GetComponentPolicyRequest): GetComponentPolicyResponse

    /**
     * Gets a component policy.
     */
    suspend fun getComponentPolicy(block: GetComponentPolicyRequest.DslBuilder.() -> Unit) = getComponentPolicy(GetComponentPolicyRequest.builder().apply(block).build())

    /**
     * Retrieves a container recipe.
     */
    suspend fun getContainerRecipe(input: GetContainerRecipeRequest): GetContainerRecipeResponse

    /**
     * Retrieves a container recipe.
     */
    suspend fun getContainerRecipe(block: GetContainerRecipeRequest.DslBuilder.() -> Unit) = getContainerRecipe(GetContainerRecipeRequest.builder().apply(block).build())

    /**
     * Retrieves the policy for a container recipe.
     */
    suspend fun getContainerRecipePolicy(input: GetContainerRecipePolicyRequest): GetContainerRecipePolicyResponse

    /**
     * Retrieves the policy for a container recipe.
     */
    suspend fun getContainerRecipePolicy(block: GetContainerRecipePolicyRequest.DslBuilder.() -> Unit) = getContainerRecipePolicy(GetContainerRecipePolicyRequest.builder().apply(block).build())

    /**
     * Gets a distribution configuration.
     */
    suspend fun getDistributionConfiguration(input: GetDistributionConfigurationRequest): GetDistributionConfigurationResponse

    /**
     * Gets a distribution configuration.
     */
    suspend fun getDistributionConfiguration(block: GetDistributionConfigurationRequest.DslBuilder.() -> Unit) = getDistributionConfiguration(GetDistributionConfigurationRequest.builder().apply(block).build())

    /**
     * Gets an image.
     */
    suspend fun getImage(input: GetImageRequest): GetImageResponse

    /**
     * Gets an image.
     */
    suspend fun getImage(block: GetImageRequest.DslBuilder.() -> Unit) = getImage(GetImageRequest.builder().apply(block).build())

    /**
     * Gets an image pipeline.
     */
    suspend fun getImagePipeline(input: GetImagePipelineRequest): GetImagePipelineResponse

    /**
     * Gets an image pipeline.
     */
    suspend fun getImagePipeline(block: GetImagePipelineRequest.DslBuilder.() -> Unit) = getImagePipeline(GetImagePipelineRequest.builder().apply(block).build())

    /**
     * Gets an image policy.
     */
    suspend fun getImagePolicy(input: GetImagePolicyRequest): GetImagePolicyResponse

    /**
     * Gets an image policy.
     */
    suspend fun getImagePolicy(block: GetImagePolicyRequest.DslBuilder.() -> Unit) = getImagePolicy(GetImagePolicyRequest.builder().apply(block).build())

    /**
     * Gets an image recipe.
     */
    suspend fun getImageRecipe(input: GetImageRecipeRequest): GetImageRecipeResponse

    /**
     * Gets an image recipe.
     */
    suspend fun getImageRecipe(block: GetImageRecipeRequest.DslBuilder.() -> Unit) = getImageRecipe(GetImageRecipeRequest.builder().apply(block).build())

    /**
     * Gets an image recipe policy.
     */
    suspend fun getImageRecipePolicy(input: GetImageRecipePolicyRequest): GetImageRecipePolicyResponse

    /**
     * Gets an image recipe policy.
     */
    suspend fun getImageRecipePolicy(block: GetImageRecipePolicyRequest.DslBuilder.() -> Unit) = getImageRecipePolicy(GetImageRecipePolicyRequest.builder().apply(block).build())

    /**
     * Gets an infrastructure configuration.
     */
    suspend fun getInfrastructureConfiguration(input: GetInfrastructureConfigurationRequest): GetInfrastructureConfigurationResponse

    /**
     * Gets an infrastructure configuration.
     */
    suspend fun getInfrastructureConfiguration(block: GetInfrastructureConfigurationRequest.DslBuilder.() -> Unit) = getInfrastructureConfiguration(GetInfrastructureConfigurationRequest.builder().apply(block).build())

    /**
     * Imports a component and transforms its data into a component document.
     */
    suspend fun importComponent(input: ImportComponentRequest): ImportComponentResponse

    /**
     * Imports a component and transforms its data into a component document.
     */
    suspend fun importComponent(block: ImportComponentRequest.DslBuilder.() -> Unit) = importComponent(ImportComponentRequest.builder().apply(block).build())

    /**
     * Returns the list of component build versions for the specified semantic version.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    suspend fun listComponentBuildVersions(input: ListComponentBuildVersionsRequest): ListComponentBuildVersionsResponse

    /**
     * Returns the list of component build versions for the specified semantic version.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    suspend fun listComponentBuildVersions(block: ListComponentBuildVersionsRequest.DslBuilder.() -> Unit) = listComponentBuildVersions(ListComponentBuildVersionsRequest.builder().apply(block).build())

    /**
     * Returns the list of component build versions for the specified semantic version.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Returns the list of component build versions for the specified semantic version.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    suspend fun listComponents(block: ListComponentsRequest.DslBuilder.() -> Unit) = listComponents(ListComponentsRequest.builder().apply(block).build())

    /**
     * Returns a list of container recipes.
     */
    suspend fun listContainerRecipes(input: ListContainerRecipesRequest): ListContainerRecipesResponse

    /**
     * Returns a list of container recipes.
     */
    suspend fun listContainerRecipes(block: ListContainerRecipesRequest.DslBuilder.() -> Unit) = listContainerRecipes(ListContainerRecipesRequest.builder().apply(block).build())

    /**
     * Returns a list of distribution configurations.
     */
    suspend fun listDistributionConfigurations(input: ListDistributionConfigurationsRequest): ListDistributionConfigurationsResponse

    /**
     * Returns a list of distribution configurations.
     */
    suspend fun listDistributionConfigurations(block: ListDistributionConfigurationsRequest.DslBuilder.() -> Unit) = listDistributionConfigurations(ListDistributionConfigurationsRequest.builder().apply(block).build())

    /**
     * Returns a list of image build versions.
     */
    suspend fun listImageBuildVersions(input: ListImageBuildVersionsRequest): ListImageBuildVersionsResponse

    /**
     * Returns a list of image build versions.
     */
    suspend fun listImageBuildVersions(block: ListImageBuildVersionsRequest.DslBuilder.() -> Unit) = listImageBuildVersions(ListImageBuildVersionsRequest.builder().apply(block).build())

    /**
     * List the Packages that are associated with an Image Build Version, as determined by Amazon EC2 Systems Manager Inventory at build time.
     */
    suspend fun listImagePackages(input: ListImagePackagesRequest): ListImagePackagesResponse

    /**
     * List the Packages that are associated with an Image Build Version, as determined by Amazon EC2 Systems Manager Inventory at build time.
     */
    suspend fun listImagePackages(block: ListImagePackagesRequest.DslBuilder.() -> Unit) = listImagePackages(ListImagePackagesRequest.builder().apply(block).build())

    /**
     * Returns a list of images created by the specified pipeline.
     */
    suspend fun listImagePipelineImages(input: ListImagePipelineImagesRequest): ListImagePipelineImagesResponse

    /**
     * Returns a list of images created by the specified pipeline.
     */
    suspend fun listImagePipelineImages(block: ListImagePipelineImagesRequest.DslBuilder.() -> Unit) = listImagePipelineImages(ListImagePipelineImagesRequest.builder().apply(block).build())

    /**
     * Returns a list of image pipelines.
     */
    suspend fun listImagePipelines(input: ListImagePipelinesRequest): ListImagePipelinesResponse

    /**
     * Returns a list of image pipelines.
     */
    suspend fun listImagePipelines(block: ListImagePipelinesRequest.DslBuilder.() -> Unit) = listImagePipelines(ListImagePipelinesRequest.builder().apply(block).build())

    /**
     * Returns a list of image recipes.
     */
    suspend fun listImageRecipes(input: ListImageRecipesRequest): ListImageRecipesResponse

    /**
     * Returns a list of image recipes.
     */
    suspend fun listImageRecipes(block: ListImageRecipesRequest.DslBuilder.() -> Unit) = listImageRecipes(ListImageRecipesRequest.builder().apply(block).build())

    /**
     * Returns the list of images that you have access to.
     */
    suspend fun listImages(input: ListImagesRequest): ListImagesResponse

    /**
     * Returns the list of images that you have access to.
     */
    suspend fun listImages(block: ListImagesRequest.DslBuilder.() -> Unit) = listImages(ListImagesRequest.builder().apply(block).build())

    /**
     * Returns a list of infrastructure configurations.
     */
    suspend fun listInfrastructureConfigurations(input: ListInfrastructureConfigurationsRequest): ListInfrastructureConfigurationsResponse

    /**
     * Returns a list of infrastructure configurations.
     */
    suspend fun listInfrastructureConfigurations(block: ListInfrastructureConfigurationsRequest.DslBuilder.() -> Unit) = listInfrastructureConfigurations(ListInfrastructureConfigurationsRequest.builder().apply(block).build())

    /**
     * Returns the list of tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns the list of tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Applies a policy to a component. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutComponentPolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putComponentPolicy(input: PutComponentPolicyRequest): PutComponentPolicyResponse

    /**
     * Applies a policy to a component. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutComponentPolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putComponentPolicy(block: PutComponentPolicyRequest.DslBuilder.() -> Unit) = putComponentPolicy(PutComponentPolicyRequest.builder().apply(block).build())

    /**
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API PutContainerImagePolicy, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    suspend fun putContainerRecipePolicy(input: PutContainerRecipePolicyRequest): PutContainerRecipePolicyResponse

    /**
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API PutContainerImagePolicy, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.
     */
    suspend fun putContainerRecipePolicy(block: PutContainerRecipePolicyRequest.DslBuilder.() -> Unit) = putContainerRecipePolicy(PutContainerRecipePolicyRequest.builder().apply(block).build())

    /**
     * Applies a policy to an image. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutImagePolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putImagePolicy(input: PutImagePolicyRequest): PutImagePolicyResponse

    /**
     * Applies a policy to an image. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutImagePolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putImagePolicy(block: PutImagePolicyRequest.DslBuilder.() -> Unit) = putImagePolicy(PutImagePolicyRequest.builder().apply(block).build())

    /**
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutImageRecipePolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putImageRecipePolicy(input: PutImageRecipePolicyRequest): PutImageRecipePolicyResponse

    /**
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare to share resources. If you call the Image Builder API
     * PutImageRecipePolicy, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to
     * all principals with whom the resource is shared.
     */
    suspend fun putImageRecipePolicy(block: PutImageRecipePolicyRequest.DslBuilder.() -> Unit) = putImageRecipePolicy(PutImageRecipePolicyRequest.builder().apply(block).build())

    /**
     * Manually triggers a pipeline to create an image.
     */
    suspend fun startImagePipelineExecution(input: StartImagePipelineExecutionRequest): StartImagePipelineExecutionResponse

    /**
     * Manually triggers a pipeline to create an image.
     */
    suspend fun startImagePipelineExecution(block: StartImagePipelineExecutionRequest.DslBuilder.() -> Unit) = startImagePipelineExecution(StartImagePipelineExecutionRequest.builder().apply(block).build())

    /**
     * Adds a tag to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds a tag to a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates a new distribution configuration. Distribution configurations define and
     * configure the outputs of your pipeline.
     */
    suspend fun updateDistributionConfiguration(input: UpdateDistributionConfigurationRequest): UpdateDistributionConfigurationResponse

    /**
     * Updates a new distribution configuration. Distribution configurations define and
     * configure the outputs of your pipeline.
     */
    suspend fun updateDistributionConfiguration(block: UpdateDistributionConfigurationRequest.DslBuilder.() -> Unit) = updateDistributionConfiguration(UpdateDistributionConfigurationRequest.builder().apply(block).build())

    /**
     * Updates an image pipeline. Image pipelines enable you to automate the creation and
     * distribution of images.
     * UpdateImagePipeline does not support selective updates for the pipeline.
     * You must specify all of the required properties in the update request, not just
     * the properties that have changed.
     */
    suspend fun updateImagePipeline(input: UpdateImagePipelineRequest): UpdateImagePipelineResponse

    /**
     * Updates an image pipeline. Image pipelines enable you to automate the creation and
     * distribution of images.
     * UpdateImagePipeline does not support selective updates for the pipeline.
     * You must specify all of the required properties in the update request, not just
     * the properties that have changed.
     */
    suspend fun updateImagePipeline(block: UpdateImagePipelineRequest.DslBuilder.() -> Unit) = updateImagePipeline(UpdateImagePipelineRequest.builder().apply(block).build())

    /**
     * Updates a new infrastructure configuration. An infrastructure configuration defines the
     * environment in which your image will be built and tested.
     */
    suspend fun updateInfrastructureConfiguration(input: UpdateInfrastructureConfigurationRequest): UpdateInfrastructureConfigurationResponse

    /**
     * Updates a new infrastructure configuration. An infrastructure configuration defines the
     * environment in which your image will be built and tested.
     */
    suspend fun updateInfrastructureConfiguration(block: UpdateInfrastructureConfigurationRequest.DslBuilder.() -> Unit) = updateInfrastructureConfiguration(UpdateInfrastructureConfigurationRequest.builder().apply(block).build())
}
