// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * In addition to your infrastruction configuration, these settings provide an extra layer of
 * control over your build instances. For instances where Image Builder installs the SSM agent,
 * you can choose whether to keep it for the AMI that you create. You can also specify commands
 * to run on launch for all of your build instances.
 */
class AdditionalInstanceConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Contains settings for the SSM agent on your build instance.
     */
    val systemsManagerAgent: SystemsManagerAgent? = builder.systemsManagerAgent
    /**
     * Use this property to provide commands or a command script to run when you launch
     * your build instance.
     * The userDataOverride property replaces any commands that Image Builder might have added to ensure
     * that SSM is installed on your Linux build instance. If you override the user data,
     * make sure that you add commands to install SSM, if it is not pre-installed on your
     * source image.
     */
    val userDataOverride: String? = builder.userDataOverride

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AdditionalInstanceConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AdditionalInstanceConfiguration(")
        append("systemsManagerAgent=$systemsManagerAgent,")
        append("userDataOverride=$userDataOverride)")
    }

    override fun hashCode(): kotlin.Int {
        var result = systemsManagerAgent?.hashCode() ?: 0
        result = 31 * result + (userDataOverride?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AdditionalInstanceConfiguration

        if (systemsManagerAgent != other.systemsManagerAgent) return false
        if (userDataOverride != other.userDataOverride) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AdditionalInstanceConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AdditionalInstanceConfiguration
        /**
         * Contains settings for the SSM agent on your build instance.
         */
        fun systemsManagerAgent(systemsManagerAgent: SystemsManagerAgent): FluentBuilder
        /**
         * Use this property to provide commands or a command script to run when you launch
         * your build instance.
         * The userDataOverride property replaces any commands that Image Builder might have added to ensure
         * that SSM is installed on your Linux build instance. If you override the user data,
         * make sure that you add commands to install SSM, if it is not pre-installed on your
         * source image.
         */
        fun userDataOverride(userDataOverride: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains settings for the SSM agent on your build instance.
         */
        var systemsManagerAgent: SystemsManagerAgent?
        /**
         * Use this property to provide commands or a command script to run when you launch
         * your build instance.
         * The userDataOverride property replaces any commands that Image Builder might have added to ensure
         * that SSM is installed on your Linux build instance. If you override the user data,
         * make sure that you add commands to install SSM, if it is not pre-installed on your
         * source image.
         */
        var userDataOverride: String?

        fun build(): AdditionalInstanceConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.SystemsManagerAgent] inside the given [block]
         */
        fun systemsManagerAgent(block: SystemsManagerAgent.DslBuilder.() -> kotlin.Unit) {
            this.systemsManagerAgent = SystemsManagerAgent.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var systemsManagerAgent: SystemsManagerAgent? = null
        override var userDataOverride: String? = null

        constructor(x: AdditionalInstanceConfiguration) : this() {
            this.systemsManagerAgent = x.systemsManagerAgent
            this.userDataOverride = x.userDataOverride
        }

        override fun build(): AdditionalInstanceConfiguration = AdditionalInstanceConfiguration(this)
        override fun systemsManagerAgent(systemsManagerAgent: SystemsManagerAgent): FluentBuilder = apply { this.systemsManagerAgent = systemsManagerAgent }
        override fun userDataOverride(userDataOverride: String): FluentBuilder = apply { this.userDataOverride = userDataOverride }
    }
}
