// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Details of an Amazon EC2 AMI.
 */
class Ami private constructor(builder: BuilderImpl) {
    /**
     * The account ID of the owner of the AMI.
     */
    val accountId: String? = builder.accountId
    /**
     * The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
     */
    val description: String? = builder.description
    /**
     * The AMI ID of the Amazon EC2 AMI.
     */
    val image: String? = builder.image
    /**
     * The name of the Amazon EC2 AMI.
     */
    val name: String? = builder.name
    /**
     * The Amazon Web Services Region of the Amazon EC2 AMI.
     */
    val region: String? = builder.region
    /**
     * Image state shows the image status and the reason for that status.
     */
    val state: ImageState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Ami = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Ami(")
        append("accountId=$accountId,")
        append("description=$description,")
        append("image=$image,")
        append("name=$name,")
        append("region=$region,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Ami

        if (accountId != other.accountId) return false
        if (description != other.description) return false
        if (image != other.image) return false
        if (name != other.name) return false
        if (region != other.region) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Ami = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Ami
        /**
         * The account ID of the owner of the AMI.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
         */
        fun description(description: String): FluentBuilder
        /**
         * The AMI ID of the Amazon EC2 AMI.
         */
        fun image(image: String): FluentBuilder
        /**
         * The name of the Amazon EC2 AMI.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Amazon Web Services Region of the Amazon EC2 AMI.
         */
        fun region(region: String): FluentBuilder
        /**
         * Image state shows the image status and the reason for that status.
         */
        fun state(state: ImageState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The account ID of the owner of the AMI.
         */
        var accountId: String?
        /**
         * The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
         */
        var description: String?
        /**
         * The AMI ID of the Amazon EC2 AMI.
         */
        var image: String?
        /**
         * The name of the Amazon EC2 AMI.
         */
        var name: String?
        /**
         * The Amazon Web Services Region of the Amazon EC2 AMI.
         */
        var region: String?
        /**
         * Image state shows the image status and the reason for that status.
         */
        var state: ImageState?

        fun build(): Ami
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        fun state(block: ImageState.DslBuilder.() -> kotlin.Unit) {
            this.state = ImageState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var description: String? = null
        override var image: String? = null
        override var name: String? = null
        override var region: String? = null
        override var state: ImageState? = null

        constructor(x: Ami) : this() {
            this.accountId = x.accountId
            this.description = x.description
            this.image = x.image
            this.name = x.name
            this.region = x.region
            this.state = x.state
        }

        override fun build(): Ami = Ami(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun image(image: String): FluentBuilder = apply { this.image = image }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun state(state: ImageState): FluentBuilder = apply { this.state = state }
    }
}
