// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Define and configure the output AMIs of the pipeline.
 */
class AmiDistributionConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The tags to apply to AMIs distributed to this Region.
     */
    val amiTags: Map<String, String>? = builder.amiTags
    /**
     * The description of the distribution configuration. Minimum and maximum length are in characters.
     */
    val description: String? = builder.description
    /**
     * The KMS key identifier used to encrypt the distributed image.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
     * instances.
     */
    val launchPermission: LaunchPermissionConfiguration? = builder.launchPermission
    /**
     * The name of the distribution configuration.
     */
    val name: String? = builder.name
    /**
     * The ID of an account to which you want to distribute an image.
     */
    val targetAccountIds: List<String>? = builder.targetAccountIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AmiDistributionConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AmiDistributionConfiguration(")
        append("amiTags=$amiTags,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("launchPermission=$launchPermission,")
        append("name=$name,")
        append("targetAccountIds=$targetAccountIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiTags?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (launchPermission?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (targetAccountIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AmiDistributionConfiguration

        if (amiTags != other.amiTags) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (launchPermission != other.launchPermission) return false
        if (name != other.name) return false
        if (targetAccountIds != other.targetAccountIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AmiDistributionConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AmiDistributionConfiguration
        /**
         * The tags to apply to AMIs distributed to this Region.
         */
        fun amiTags(amiTags: Map<String, String>): FluentBuilder
        /**
         * The description of the distribution configuration. Minimum and maximum length are in characters.
         */
        fun description(description: String): FluentBuilder
        /**
         * The KMS key identifier used to encrypt the distributed image.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
         * instances.
         */
        fun launchPermission(launchPermission: LaunchPermissionConfiguration): FluentBuilder
        /**
         * The name of the distribution configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The ID of an account to which you want to distribute an image.
         */
        fun targetAccountIds(targetAccountIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The tags to apply to AMIs distributed to this Region.
         */
        var amiTags: Map<String, String>?
        /**
         * The description of the distribution configuration. Minimum and maximum length are in characters.
         */
        var description: String?
        /**
         * The KMS key identifier used to encrypt the distributed image.
         */
        var kmsKeyId: String?
        /**
         * Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
         * instances.
         */
        var launchPermission: LaunchPermissionConfiguration?
        /**
         * The name of the distribution configuration.
         */
        var name: String?
        /**
         * The ID of an account to which you want to distribute an image.
         */
        var targetAccountIds: List<String>?

        fun build(): AmiDistributionConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LaunchPermissionConfiguration] inside the given [block]
         */
        fun launchPermission(block: LaunchPermissionConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.launchPermission = LaunchPermissionConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amiTags: Map<String, String>? = null
        override var description: String? = null
        override var kmsKeyId: String? = null
        override var launchPermission: LaunchPermissionConfiguration? = null
        override var name: String? = null
        override var targetAccountIds: List<String>? = null

        constructor(x: AmiDistributionConfiguration) : this() {
            this.amiTags = x.amiTags
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.launchPermission = x.launchPermission
            this.name = x.name
            this.targetAccountIds = x.targetAccountIds
        }

        override fun build(): AmiDistributionConfiguration = AmiDistributionConfiguration(this)
        override fun amiTags(amiTags: Map<String, String>): FluentBuilder = apply { this.amiTags = amiTags }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun launchPermission(launchPermission: LaunchPermissionConfiguration): FluentBuilder = apply { this.launchPermission = launchPermission }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun targetAccountIds(targetAccountIds: List<String>): FluentBuilder = apply { this.targetAccountIds = targetAccountIds }
    }
}
