// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A detailed view of a component.
 */
class Component private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    val arn: String? = builder.arn
    /**
     * The change description of the component.
     */
    val changeDescription: String? = builder.changeDescription
    /**
     * The data of the component.
     */
    val data: String? = builder.data
    /**
     * The date that the component was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The description of the component.
     */
    val description: String? = builder.description
    /**
     * The encryption status of the component.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The KMS key identifier used to encrypt the component.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the component.
     */
    val name: String? = builder.name
    /**
     * The owner of the component.
     */
    val owner: String? = builder.owner
    /**
     * Contains parameter details for each of the parameters that are defined for the component.
     */
    val parameters: List<ComponentParameterDetail>? = builder.parameters
    /**
     * The platform of the component.
     */
    val platform: Platform? = builder.platform
    /**
     * The operating system (OS) version supported by the component. If the OS information is
     * available, a prefix match is performed against the parent image OS version during image recipe
     * creation.
     */
    val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The tags associated with the component.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of the component denotes whether the component is used to build the image or only
     * to test it.
     */
    val type: ComponentType? = builder.type
    /**
     * The version of the component.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Component = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Component(")
        append("arn=$arn,")
        append("changeDescription=$changeDescription,")
        append("data=$data,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("owner=$owner,")
        append("parameters=$parameters,")
        append("platform=$platform,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (changeDescription?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Component

        if (arn != other.arn) return false
        if (changeDescription != other.changeDescription) return false
        if (data != other.data) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parameters != other.parameters) return false
        if (platform != other.platform) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Component = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Component
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The change description of the component.
         */
        fun changeDescription(changeDescription: String): FluentBuilder
        /**
         * The data of the component.
         */
        fun data(data: String): FluentBuilder
        /**
         * The date that the component was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The description of the component.
         */
        fun description(description: String): FluentBuilder
        /**
         * The encryption status of the component.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The KMS key identifier used to encrypt the component.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the component.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * Contains parameter details for each of the parameters that are defined for the component.
         */
        fun parameters(parameters: List<ComponentParameterDetail>): FluentBuilder
        /**
         * The platform of the component.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder
        /**
         * The tags associated with the component.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        fun type(type: ComponentType): FluentBuilder
        /**
         * The version of the component.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        var arn: String?
        /**
         * The change description of the component.
         */
        var changeDescription: String?
        /**
         * The data of the component.
         */
        var data: String?
        /**
         * The date that the component was created.
         */
        var dateCreated: String?
        /**
         * The description of the component.
         */
        var description: String?
        /**
         * The encryption status of the component.
         */
        var encrypted: Boolean?
        /**
         * The KMS key identifier used to encrypt the component.
         */
        var kmsKeyId: String?
        /**
         * The name of the component.
         */
        var name: String?
        /**
         * The owner of the component.
         */
        var owner: String?
        /**
         * Contains parameter details for each of the parameters that are defined for the component.
         */
        var parameters: List<ComponentParameterDetail>?
        /**
         * The platform of the component.
         */
        var platform: Platform?
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        var supportedOsVersions: List<String>?
        /**
         * The tags associated with the component.
         */
        var tags: Map<String, String>?
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        var type: ComponentType?
        /**
         * The version of the component.
         */
        var version: String?

        fun build(): Component
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var changeDescription: String? = null
        override var data: String? = null
        override var dateCreated: String? = null
        override var description: String? = null
        override var encrypted: Boolean? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var parameters: List<ComponentParameterDetail>? = null
        override var platform: Platform? = null
        override var supportedOsVersions: List<String>? = null
        override var tags: Map<String, String>? = null
        override var type: ComponentType? = null
        override var version: String? = null

        constructor(x: Component) : this() {
            this.arn = x.arn
            this.changeDescription = x.changeDescription
            this.data = x.data
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.owner = x.owner
            this.parameters = x.parameters
            this.platform = x.platform
            this.supportedOsVersions = x.supportedOsVersions
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        override fun build(): Component = Component(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun changeDescription(changeDescription: String): FluentBuilder = apply { this.changeDescription = changeDescription }
        override fun data(data: String): FluentBuilder = apply { this.data = data }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun parameters(parameters: List<ComponentParameterDetail>): FluentBuilder = apply { this.parameters = parameters }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder = apply { this.supportedOsVersions = supportedOsVersions }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ComponentType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
