// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A high-level summary of a component.
 */
class ComponentSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    val arn: String? = builder.arn
    /**
     * The change description of the component.
     */
    val changeDescription: String? = builder.changeDescription
    /**
     * The date that the component was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The description of the component.
     */
    val description: String? = builder.description
    /**
     * The name of the component.
     */
    val name: String? = builder.name
    /**
     * The owner of the component.
     */
    val owner: String? = builder.owner
    /**
     * The platform of the component.
     */
    val platform: Platform? = builder.platform
    /**
     * The operating system (OS) version supported by the component. If the OS information is
     * available, a prefix match is performed against the parent image OS version during image recipe
     * creation.
     */
    val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The tags associated with the component.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of the component denotes whether the component is used to build the image or only
     * to test it.
     */
    val type: ComponentType? = builder.type
    /**
     * The version of the component.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentSummary(")
        append("arn=$arn,")
        append("changeDescription=$changeDescription,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (changeDescription?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentSummary

        if (arn != other.arn) return false
        if (changeDescription != other.changeDescription) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentSummary
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The change description of the component.
         */
        fun changeDescription(changeDescription: String): FluentBuilder
        /**
         * The date that the component was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The description of the component.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the component.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The platform of the component.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder
        /**
         * The tags associated with the component.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        fun type(type: ComponentType): FluentBuilder
        /**
         * The version of the component.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        var arn: String?
        /**
         * The change description of the component.
         */
        var changeDescription: String?
        /**
         * The date that the component was created.
         */
        var dateCreated: String?
        /**
         * The description of the component.
         */
        var description: String?
        /**
         * The name of the component.
         */
        var name: String?
        /**
         * The owner of the component.
         */
        var owner: String?
        /**
         * The platform of the component.
         */
        var platform: Platform?
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        var supportedOsVersions: List<String>?
        /**
         * The tags associated with the component.
         */
        var tags: Map<String, String>?
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        var type: ComponentType?
        /**
         * The version of the component.
         */
        var version: String?

        fun build(): ComponentSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var changeDescription: String? = null
        override var dateCreated: String? = null
        override var description: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var platform: Platform? = null
        override var supportedOsVersions: List<String>? = null
        override var tags: Map<String, String>? = null
        override var type: ComponentType? = null
        override var version: String? = null

        constructor(x: ComponentSummary) : this() {
            this.arn = x.arn
            this.changeDescription = x.changeDescription
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.platform = x.platform
            this.supportedOsVersions = x.supportedOsVersions
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        override fun build(): ComponentSummary = ComponentSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun changeDescription(changeDescription: String): FluentBuilder = apply { this.changeDescription = changeDescription }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder = apply { this.supportedOsVersions = supportedOsVersions }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ComponentType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
