// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * The defining characteristics of a specific version of an Amazon Web Services TOE component.
 */
class ComponentVersion private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     * Semantic versioning is included in each object's Amazon Resource Name (ARN),
     * at the level that applies to that object as follows:
     * <ol>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
     * either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </ol>
     */
    val arn: String? = builder.arn
    /**
     * The date that the component was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The description of the component.
     */
    val description: String? = builder.description
    /**
     * The name of the component.
     */
    val name: String? = builder.name
    /**
     * The owner of the component.
     */
    val owner: String? = builder.owner
    /**
     * The platform of the component.
     */
    val platform: Platform? = builder.platform
    /**
     * he operating system (OS) version supported by the component. If the OS information is
     * available, a prefix match is performed against the parent image OS version during image recipe
     * creation.
     */
    val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The type of the component denotes whether the component is used to build the image or only
     * to test it.
     */
    val type: ComponentType? = builder.type
    /**
     * The semantic version of the component.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ComponentVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentVersion(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComponentVersion

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ComponentVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ComponentVersion
        /**
         * The Amazon Resource Name (ARN) of the component.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date that the component was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The description of the component.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the component.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The platform of the component.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * he operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        fun type(type: ComponentType): FluentBuilder
        /**
         * The semantic version of the component.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        var arn: String?
        /**
         * The date that the component was created.
         */
        var dateCreated: String?
        /**
         * The description of the component.
         */
        var description: String?
        /**
         * The name of the component.
         */
        var name: String?
        /**
         * The owner of the component.
         */
        var owner: String?
        /**
         * The platform of the component.
         */
        var platform: Platform?
        /**
         * he operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        var supportedOsVersions: List<String>?
        /**
         * The type of the component denotes whether the component is used to build the image or only
         * to test it.
         */
        var type: ComponentType?
        /**
         * The semantic version of the component.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        var version: String?

        fun build(): ComponentVersion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var description: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var platform: Platform? = null
        override var supportedOsVersions: List<String>? = null
        override var type: ComponentType? = null
        override var version: String? = null

        constructor(x: ComponentVersion) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.platform = x.platform
            this.supportedOsVersions = x.supportedOsVersions
            this.type = x.type
            this.version = x.version
        }

        override fun build(): ComponentVersion = ComponentVersion(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder = apply { this.supportedOsVersions = supportedOsVersions }
        override fun type(type: ComponentType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
