// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A container recipe.
 */
class ContainerRecipe private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the container recipe.
     * Semantic versioning is included in each object's Amazon Resource Name (ARN),
     * at the level that applies to that object as follows:
     * <ol>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
     * either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </ol>
     */
    val arn: String? = builder.arn
    /**
     * Components for build and test that are included in the container recipe.
     */
    val components: List<ComponentConfiguration>? = builder.components
    /**
     * Specifies the type of container, such as Docker.
     */
    val containerType: ContainerType? = builder.containerType
    /**
     * The date when this container recipe was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The description of the container recipe.
     */
    val description: String? = builder.description
    /**
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
     */
    val dockerfileTemplateData: String? = builder.dockerfileTemplateData
    /**
     * A flag that indicates if the target container is encrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    val instanceConfiguration: InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the container recipe.
     */
    val name: String? = builder.name
    /**
     * The owner of the container recipe.
     */
    val owner: String? = builder.owner
    /**
     * The source image for the container recipe.
     */
    val parentImage: String? = builder.parentImage
    /**
     * The system platform for the container, such as Windows or Linux.
     */
    val platform: Platform? = builder.platform
    /**
     * Tags that are attached to the container recipe.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The destination repository for the container image.
     */
    val targetRepository: TargetContainerRepository? = builder.targetRepository
    /**
     * The semantic version of the container recipe.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    val version: String? = builder.version
    /**
     * The working directory for use during build and test workflows.
     */
    val workingDirectory: String? = builder.workingDirectory

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ContainerRecipe = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerRecipe(")
        append("arn=$arn,")
        append("components=$components,")
        append("containerType=$containerType,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("dockerfileTemplateData=$dockerfileTemplateData,")
        append("encrypted=$encrypted,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags,")
        append("targetRepository=$targetRepository,")
        append("version=$version,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateData?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRepository?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ContainerRecipe

        if (arn != other.arn) return false
        if (components != other.components) return false
        if (containerType != other.containerType) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (dockerfileTemplateData != other.dockerfileTemplateData) return false
        if (encrypted != other.encrypted) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false
        if (targetRepository != other.targetRepository) return false
        if (version != other.version) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ContainerRecipe = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ContainerRecipe
        /**
         * The Amazon Resource Name (ARN) of the container recipe.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        fun arn(arn: String): FluentBuilder
        /**
         * Components for build and test that are included in the container recipe.
         */
        fun components(components: List<ComponentConfiguration>): FluentBuilder
        /**
         * Specifies the type of container, such as Docker.
         */
        fun containerType(containerType: ContainerType): FluentBuilder
        /**
         * The date when this container recipe was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The description of the container recipe.
         */
        fun description(description: String): FluentBuilder
        /**
         * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
         */
        fun dockerfileTemplateData(dockerfileTemplateData: String): FluentBuilder
        /**
         * A flag that indicates if the target container is encrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        fun instanceConfiguration(instanceConfiguration: InstanceConfiguration): FluentBuilder
        /**
         * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the container recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the container recipe.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The source image for the container recipe.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * The system platform for the container, such as Windows or Linux.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * Tags that are attached to the container recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The destination repository for the container image.
         */
        fun targetRepository(targetRepository: TargetContainerRepository): FluentBuilder
        /**
         * The semantic version of the container recipe.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        fun version(version: String): FluentBuilder
        /**
         * The working directory for use during build and test workflows.
         */
        fun workingDirectory(workingDirectory: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the container recipe.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        var arn: String?
        /**
         * Components for build and test that are included in the container recipe.
         */
        var components: List<ComponentConfiguration>?
        /**
         * Specifies the type of container, such as Docker.
         */
        var containerType: ContainerType?
        /**
         * The date when this container recipe was created.
         */
        var dateCreated: String?
        /**
         * The description of the container recipe.
         */
        var description: String?
        /**
         * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
         */
        var dockerfileTemplateData: String?
        /**
         * A flag that indicates if the target container is encrypted.
         */
        var encrypted: Boolean?
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        var instanceConfiguration: InstanceConfiguration?
        /**
         * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         */
        var kmsKeyId: String?
        /**
         * The name of the container recipe.
         */
        var name: String?
        /**
         * The owner of the container recipe.
         */
        var owner: String?
        /**
         * The source image for the container recipe.
         */
        var parentImage: String?
        /**
         * The system platform for the container, such as Windows or Linux.
         */
        var platform: Platform?
        /**
         * Tags that are attached to the container recipe.
         */
        var tags: Map<String, String>?
        /**
         * The destination repository for the container image.
         */
        var targetRepository: TargetContainerRepository?
        /**
         * The semantic version of the container recipe.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        var version: String?
        /**
         * The working directory for use during build and test workflows.
         */
        var workingDirectory: String?

        fun build(): ContainerRecipe
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration] inside the given [block]
         */
        fun instanceConfiguration(block: InstanceConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.instanceConfiguration = InstanceConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository] inside the given [block]
         */
        fun targetRepository(block: TargetContainerRepository.DslBuilder.() -> kotlin.Unit) {
            this.targetRepository = TargetContainerRepository.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var components: List<ComponentConfiguration>? = null
        override var containerType: ContainerType? = null
        override var dateCreated: String? = null
        override var description: String? = null
        override var dockerfileTemplateData: String? = null
        override var encrypted: Boolean? = null
        override var instanceConfiguration: InstanceConfiguration? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var parentImage: String? = null
        override var platform: Platform? = null
        override var tags: Map<String, String>? = null
        override var targetRepository: TargetContainerRepository? = null
        override var version: String? = null
        override var workingDirectory: String? = null

        constructor(x: ContainerRecipe) : this() {
            this.arn = x.arn
            this.components = x.components
            this.containerType = x.containerType
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.dockerfileTemplateData = x.dockerfileTemplateData
            this.encrypted = x.encrypted
            this.instanceConfiguration = x.instanceConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
            this.targetRepository = x.targetRepository
            this.version = x.version
            this.workingDirectory = x.workingDirectory
        }

        override fun build(): ContainerRecipe = ContainerRecipe(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun components(components: List<ComponentConfiguration>): FluentBuilder = apply { this.components = components }
        override fun containerType(containerType: ContainerType): FluentBuilder = apply { this.containerType = containerType }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dockerfileTemplateData(dockerfileTemplateData: String): FluentBuilder = apply { this.dockerfileTemplateData = dockerfileTemplateData }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun instanceConfiguration(instanceConfiguration: InstanceConfiguration): FluentBuilder = apply { this.instanceConfiguration = instanceConfiguration }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetRepository(targetRepository: TargetContainerRepository): FluentBuilder = apply { this.targetRepository = targetRepository }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
        override fun workingDirectory(workingDirectory: String): FluentBuilder = apply { this.workingDirectory = workingDirectory }
    }
}
