// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A summary of a container recipe
 */
class ContainerRecipeSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the container recipe.
     */
    val arn: String? = builder.arn
    /**
     * Specifies the type of container, such as "Docker".
     */
    val containerType: ContainerType? = builder.containerType
    /**
     * The date when this container recipe was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The name of the container recipe.
     */
    val name: String? = builder.name
    /**
     * The owner of the container recipe.
     */
    val owner: String? = builder.owner
    /**
     * The source image for the container recipe.
     */
    val parentImage: String? = builder.parentImage
    /**
     * The system platform for the container, such as Windows or Linux.
     */
    val platform: Platform? = builder.platform
    /**
     * Tags that are attached to the container recipe.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ContainerRecipeSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerRecipeSummary(")
        append("arn=$arn,")
        append("containerType=$containerType,")
        append("dateCreated=$dateCreated,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ContainerRecipeSummary

        if (arn != other.arn) return false
        if (containerType != other.containerType) return false
        if (dateCreated != other.dateCreated) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ContainerRecipeSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ContainerRecipeSummary
        /**
         * The Amazon Resource Name (ARN) of the container recipe.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * Specifies the type of container, such as "Docker".
         */
        fun containerType(containerType: ContainerType): FluentBuilder
        /**
         * The date when this container recipe was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The name of the container recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the container recipe.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The source image for the container recipe.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * The system platform for the container, such as Windows or Linux.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * Tags that are attached to the container recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the container recipe.
         */
        var arn: String?
        /**
         * Specifies the type of container, such as "Docker".
         */
        var containerType: ContainerType?
        /**
         * The date when this container recipe was created.
         */
        var dateCreated: String?
        /**
         * The name of the container recipe.
         */
        var name: String?
        /**
         * The owner of the container recipe.
         */
        var owner: String?
        /**
         * The source image for the container recipe.
         */
        var parentImage: String?
        /**
         * The system platform for the container, such as Windows or Linux.
         */
        var platform: Platform?
        /**
         * Tags that are attached to the container recipe.
         */
        var tags: Map<String, String>?

        fun build(): ContainerRecipeSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var containerType: ContainerType? = null
        override var dateCreated: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var parentImage: String? = null
        override var platform: Platform? = null
        override var tags: Map<String, String>? = null

        constructor(x: ContainerRecipeSummary) : this() {
            this.arn = x.arn
            this.containerType = x.containerType
            this.dateCreated = x.dateCreated
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
        }

        override fun build(): ContainerRecipeSummary = ContainerRecipeSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun containerType(containerType: ContainerType): FluentBuilder = apply { this.containerType = containerType }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
