// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateComponentRequest private constructor(builder: BuilderImpl) {
    /**
     * The change description of the component. Describes what change has been made in this
     * version, or what makes this version different from other versions of this component.
     */
    val changeDescription: String? = builder.changeDescription
    /**
     * The idempotency token of the component.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The data of the component. Used to specify the data inline. Either data or
     * uri can be used to specify the data within the component.
     */
    val data: String? = builder.data
    /**
     * The description of the component. Describes the contents of the component.
     */
    val description: String? = builder.description
    /**
     * The ID of the KMS key that should be used to encrypt this component.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the component.
     */
    val name: String? = builder.name
    /**
     * The platform of the component.
     */
    val platform: Platform? = builder.platform
    /**
     * The semantic version of the component. This version follows the semantic version syntax.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     */
    val semanticVersion: String? = builder.semanticVersion
    /**
     * The operating system (OS) version supported by the component. If the OS information is
     * available, a prefix match is performed against the parent image OS version during image recipe
     * creation.
     */
    val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The tags of the component.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
     * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
     * quota. Either data or uri can be used to specify the data within the
     * component.
     */
    val uri: String? = builder.uri

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateComponentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentRequest(")
        append("changeDescription=$changeDescription,")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("platform=$platform,")
        append("semanticVersion=$semanticVersion,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("tags=$tags,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeDescription?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateComponentRequest

        if (changeDescription != other.changeDescription) return false
        if (clientToken != other.clientToken) return false
        if (data != other.data) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (semanticVersion != other.semanticVersion) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (tags != other.tags) return false
        if (uri != other.uri) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateComponentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateComponentRequest
        /**
         * The change description of the component. Describes what change has been made in this
         * version, or what makes this version different from other versions of this component.
         */
        fun changeDescription(changeDescription: String): FluentBuilder
        /**
         * The idempotency token of the component.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The data of the component. Used to specify the data inline. Either data or
         * uri can be used to specify the data within the component.
         */
        fun data(data: String): FluentBuilder
        /**
         * The description of the component. Describes the contents of the component.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the KMS key that should be used to encrypt this component.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun name(name: String): FluentBuilder
        /**
         * The platform of the component.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The semantic version of the component. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        fun semanticVersion(semanticVersion: String): FluentBuilder
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder
        /**
         * The tags of the component.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
         * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
         * quota. Either data or uri can be used to specify the data within the
         * component.
         */
        fun uri(uri: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The change description of the component. Describes what change has been made in this
         * version, or what makes this version different from other versions of this component.
         */
        var changeDescription: String?
        /**
         * The idempotency token of the component.
         */
        var clientToken: String?
        /**
         * The data of the component. Used to specify the data inline. Either data or
         * uri can be used to specify the data within the component.
         */
        var data: String?
        /**
         * The description of the component. Describes the contents of the component.
         */
        var description: String?
        /**
         * The ID of the KMS key that should be used to encrypt this component.
         */
        var kmsKeyId: String?
        /**
         * The name of the component.
         */
        var name: String?
        /**
         * The platform of the component.
         */
        var platform: Platform?
        /**
         * The semantic version of the component. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        var semanticVersion: String?
        /**
         * The operating system (OS) version supported by the component. If the OS information is
         * available, a prefix match is performed against the parent image OS version during image recipe
         * creation.
         */
        var supportedOsVersions: List<String>?
        /**
         * The tags of the component.
         */
        var tags: Map<String, String>?
        /**
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
         * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
         * quota. Either data or uri can be used to specify the data within the
         * component.
         */
        var uri: String?

        fun build(): CreateComponentRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var changeDescription: String? = null
        override var clientToken: String? = null
        override var data: String? = null
        override var description: String? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var platform: Platform? = null
        override var semanticVersion: String? = null
        override var supportedOsVersions: List<String>? = null
        override var tags: Map<String, String>? = null
        override var uri: String? = null

        constructor(x: CreateComponentRequest) : this() {
            this.changeDescription = x.changeDescription
            this.clientToken = x.clientToken
            this.data = x.data
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.platform = x.platform
            this.semanticVersion = x.semanticVersion
            this.supportedOsVersions = x.supportedOsVersions
            this.tags = x.tags
            this.uri = x.uri
        }

        override fun build(): CreateComponentRequest = CreateComponentRequest(this)
        override fun changeDescription(changeDescription: String): FluentBuilder = apply { this.changeDescription = changeDescription }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun data(data: String): FluentBuilder = apply { this.data = data }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun semanticVersion(semanticVersion: String): FluentBuilder = apply { this.semanticVersion = semanticVersion }
        override fun supportedOsVersions(supportedOsVersions: List<String>): FluentBuilder = apply { this.supportedOsVersions = supportedOsVersions }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun uri(uri: String): FluentBuilder = apply { this.uri = uri }
    }
}
