// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateContainerRecipeRequest private constructor(builder: BuilderImpl) {
    /**
     * The client token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Components for build and test that are included in the container recipe.
     */
    val components: List<ComponentConfiguration>? = builder.components
    /**
     * The type of container to create.
     */
    val containerType: ContainerType? = builder.containerType
    /**
     * The description of the container recipe.
     */
    val description: String? = builder.description
    /**
     * The Dockerfile template used to build your image as an inline data blob.
     */
    val dockerfileTemplateData: String? = builder.dockerfileTemplateData
    /**
     * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
     */
    val dockerfileTemplateUri: String? = builder.dockerfileTemplateUri
    /**
     * Specifies the operating system version for the source image.
     */
    val imageOsVersionOverride: String? = builder.imageOsVersionOverride
    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    val instanceConfiguration: InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Identifies which KMS key is used to encrypt the container image.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the container recipe.
     */
    val name: String? = builder.name
    /**
     * The source image for the container recipe.
     */
    val parentImage: String? = builder.parentImage
    /**
     * Specifies the operating system platform when you use a custom source image.
     */
    val platformOverride: Platform? = builder.platformOverride
    /**
     * The semantic version of the container recipe. This version follows the semantic version syntax.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     */
    val semanticVersion: String? = builder.semanticVersion
    /**
     * Tags that are attached to the container recipe.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The destination repository for the container image.
     */
    val targetRepository: TargetContainerRepository? = builder.targetRepository
    /**
     * The working directory for use during build and test workflows.
     */
    val workingDirectory: String? = builder.workingDirectory

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateContainerRecipeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContainerRecipeRequest(")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("containerType=$containerType,")
        append("description=$description,")
        append("dockerfileTemplateData=$dockerfileTemplateData,")
        append("dockerfileTemplateUri=$dockerfileTemplateUri,")
        append("imageOsVersionOverride=$imageOsVersionOverride,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("parentImage=$parentImage,")
        append("platformOverride=$platformOverride,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("targetRepository=$targetRepository,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateData?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateUri?.hashCode() ?: 0)
        result = 31 * result + (imageOsVersionOverride?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platformOverride?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRepository?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateContainerRecipeRequest

        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (containerType != other.containerType) return false
        if (description != other.description) return false
        if (dockerfileTemplateData != other.dockerfileTemplateData) return false
        if (dockerfileTemplateUri != other.dockerfileTemplateUri) return false
        if (imageOsVersionOverride != other.imageOsVersionOverride) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (parentImage != other.parentImage) return false
        if (platformOverride != other.platformOverride) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (targetRepository != other.targetRepository) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateContainerRecipeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateContainerRecipeRequest
        /**
         * The client token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Components for build and test that are included in the container recipe.
         */
        fun components(components: List<ComponentConfiguration>): FluentBuilder
        /**
         * The type of container to create.
         */
        fun containerType(containerType: ContainerType): FluentBuilder
        /**
         * The description of the container recipe.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Dockerfile template used to build your image as an inline data blob.
         */
        fun dockerfileTemplateData(dockerfileTemplateData: String): FluentBuilder
        /**
         * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
         */
        fun dockerfileTemplateUri(dockerfileTemplateUri: String): FluentBuilder
        /**
         * Specifies the operating system version for the source image.
         */
        fun imageOsVersionOverride(imageOsVersionOverride: String): FluentBuilder
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        fun instanceConfiguration(instanceConfiguration: InstanceConfiguration): FluentBuilder
        /**
         * Identifies which KMS key is used to encrypt the container image.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the container recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The source image for the container recipe.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * Specifies the operating system platform when you use a custom source image.
         */
        fun platformOverride(platformOverride: Platform): FluentBuilder
        /**
         * The semantic version of the container recipe. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        fun semanticVersion(semanticVersion: String): FluentBuilder
        /**
         * Tags that are attached to the container recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The destination repository for the container image.
         */
        fun targetRepository(targetRepository: TargetContainerRepository): FluentBuilder
        /**
         * The working directory for use during build and test workflows.
         */
        fun workingDirectory(workingDirectory: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The client token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * Components for build and test that are included in the container recipe.
         */
        var components: List<ComponentConfiguration>?
        /**
         * The type of container to create.
         */
        var containerType: ContainerType?
        /**
         * The description of the container recipe.
         */
        var description: String?
        /**
         * The Dockerfile template used to build your image as an inline data blob.
         */
        var dockerfileTemplateData: String?
        /**
         * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
         */
        var dockerfileTemplateUri: String?
        /**
         * Specifies the operating system version for the source image.
         */
        var imageOsVersionOverride: String?
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        var instanceConfiguration: InstanceConfiguration?
        /**
         * Identifies which KMS key is used to encrypt the container image.
         */
        var kmsKeyId: String?
        /**
         * The name of the container recipe.
         */
        var name: String?
        /**
         * The source image for the container recipe.
         */
        var parentImage: String?
        /**
         * Specifies the operating system platform when you use a custom source image.
         */
        var platformOverride: Platform?
        /**
         * The semantic version of the container recipe. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        var semanticVersion: String?
        /**
         * Tags that are attached to the container recipe.
         */
        var tags: Map<String, String>?
        /**
         * The destination repository for the container image.
         */
        var targetRepository: TargetContainerRepository?
        /**
         * The working directory for use during build and test workflows.
         */
        var workingDirectory: String?

        fun build(): CreateContainerRecipeRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration] inside the given [block]
         */
        fun instanceConfiguration(block: InstanceConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.instanceConfiguration = InstanceConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository] inside the given [block]
         */
        fun targetRepository(block: TargetContainerRepository.DslBuilder.() -> kotlin.Unit) {
            this.targetRepository = TargetContainerRepository.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var components: List<ComponentConfiguration>? = null
        override var containerType: ContainerType? = null
        override var description: String? = null
        override var dockerfileTemplateData: String? = null
        override var dockerfileTemplateUri: String? = null
        override var imageOsVersionOverride: String? = null
        override var instanceConfiguration: InstanceConfiguration? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var parentImage: String? = null
        override var platformOverride: Platform? = null
        override var semanticVersion: String? = null
        override var tags: Map<String, String>? = null
        override var targetRepository: TargetContainerRepository? = null
        override var workingDirectory: String? = null

        constructor(x: CreateContainerRecipeRequest) : this() {
            this.clientToken = x.clientToken
            this.components = x.components
            this.containerType = x.containerType
            this.description = x.description
            this.dockerfileTemplateData = x.dockerfileTemplateData
            this.dockerfileTemplateUri = x.dockerfileTemplateUri
            this.imageOsVersionOverride = x.imageOsVersionOverride
            this.instanceConfiguration = x.instanceConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.parentImage = x.parentImage
            this.platformOverride = x.platformOverride
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.targetRepository = x.targetRepository
            this.workingDirectory = x.workingDirectory
        }

        override fun build(): CreateContainerRecipeRequest = CreateContainerRecipeRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun components(components: List<ComponentConfiguration>): FluentBuilder = apply { this.components = components }
        override fun containerType(containerType: ContainerType): FluentBuilder = apply { this.containerType = containerType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dockerfileTemplateData(dockerfileTemplateData: String): FluentBuilder = apply { this.dockerfileTemplateData = dockerfileTemplateData }
        override fun dockerfileTemplateUri(dockerfileTemplateUri: String): FluentBuilder = apply { this.dockerfileTemplateUri = dockerfileTemplateUri }
        override fun imageOsVersionOverride(imageOsVersionOverride: String): FluentBuilder = apply { this.imageOsVersionOverride = imageOsVersionOverride }
        override fun instanceConfiguration(instanceConfiguration: InstanceConfiguration): FluentBuilder = apply { this.instanceConfiguration = instanceConfiguration }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun platformOverride(platformOverride: Platform): FluentBuilder = apply { this.platformOverride = platformOverride }
        override fun semanticVersion(semanticVersion: String): FluentBuilder = apply { this.semanticVersion = semanticVersion }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetRepository(targetRepository: TargetContainerRepository): FluentBuilder = apply { this.targetRepository = targetRepository }
        override fun workingDirectory(workingDirectory: String): FluentBuilder = apply { this.workingDirectory = workingDirectory }
    }
}
