// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateImagePipelineRequest private constructor(builder: BuilderImpl) {
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.
     */
    val containerRecipeArn: String? = builder.containerRecipeArn
    /**
     * The description of the image pipeline.
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
     * configure and distribute images created by this image pipeline.
     */
    val distributionConfigurationArn: String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating
     * system (OS) version and package list. This information is used to enhance the overall
     * experience of using EC2 Image Builder. Enabled by default.
     */
    val enhancedImageMetadataEnabled: Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
     * created by this image pipeline.
     */
    val imageRecipeArn: String? = builder.imageRecipeArn
    /**
     * The image test configuration of the image pipeline.
     */
    val imageTestsConfiguration: ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
     * build images created by this image pipeline.
     */
    val infrastructureConfigurationArn: String? = builder.infrastructureConfigurationArn
    /**
     * The name of the image pipeline.
     */
    val name: String? = builder.name
    /**
     * The schedule of the image pipeline.
     */
    val schedule: Schedule? = builder.schedule
    /**
     * The status of the image pipeline.
     */
    val status: PipelineStatus? = builder.status
    /**
     * The tags of the image pipeline.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateImagePipelineRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImagePipelineRequest(")
        append("clientToken=$clientToken,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("description=$description,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("name=$name,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateImagePipelineRequest

        if (clientToken != other.clientToken) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (description != other.description) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (name != other.name) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateImagePipelineRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateImagePipelineRequest
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.
         */
        fun containerRecipeArn(containerRecipeArn: String): FluentBuilder
        /**
         * The description of the image pipeline.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
         * configure and distribute images created by this image pipeline.
         */
        fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
         * created by this image pipeline.
         */
        fun imageRecipeArn(imageRecipeArn: String): FluentBuilder
        /**
         * The image test configuration of the image pipeline.
         */
        fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
         * build images created by this image pipeline.
         */
        fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder
        /**
         * The name of the image pipeline.
         */
        fun name(name: String): FluentBuilder
        /**
         * The schedule of the image pipeline.
         */
        fun schedule(schedule: Schedule): FluentBuilder
        /**
         * The status of the image pipeline.
         */
        fun status(status: PipelineStatus): FluentBuilder
        /**
         * The tags of the image pipeline.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.
         */
        var containerRecipeArn: String?
        /**
         * The description of the image pipeline.
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
         * configure and distribute images created by this image pipeline.
         */
        var distributionConfigurationArn: String?
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        var enhancedImageMetadataEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
         * created by this image pipeline.
         */
        var imageRecipeArn: String?
        /**
         * The image test configuration of the image pipeline.
         */
        var imageTestsConfiguration: ImageTestsConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
         * build images created by this image pipeline.
         */
        var infrastructureConfigurationArn: String?
        /**
         * The name of the image pipeline.
         */
        var name: String?
        /**
         * The schedule of the image pipeline.
         */
        var schedule: Schedule?
        /**
         * The status of the image pipeline.
         */
        var status: PipelineStatus?
        /**
         * The tags of the image pipeline.
         */
        var tags: Map<String, String>?

        fun build(): CreateImagePipelineRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        fun imageTestsConfiguration(block: ImageTestsConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = ImageTestsConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Schedule] inside the given [block]
         */
        fun schedule(block: Schedule.DslBuilder.() -> kotlin.Unit) {
            this.schedule = Schedule.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var containerRecipeArn: String? = null
        override var description: String? = null
        override var distributionConfigurationArn: String? = null
        override var enhancedImageMetadataEnabled: Boolean? = null
        override var imageRecipeArn: String? = null
        override var imageTestsConfiguration: ImageTestsConfiguration? = null
        override var infrastructureConfigurationArn: String? = null
        override var name: String? = null
        override var schedule: Schedule? = null
        override var status: PipelineStatus? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateImagePipelineRequest) : this() {
            this.clientToken = x.clientToken
            this.containerRecipeArn = x.containerRecipeArn
            this.description = x.description
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipeArn = x.imageRecipeArn
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.name = x.name
            this.schedule = x.schedule
            this.status = x.status
            this.tags = x.tags
        }

        override fun build(): CreateImagePipelineRequest = CreateImagePipelineRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun containerRecipeArn(containerRecipeArn: String): FluentBuilder = apply { this.containerRecipeArn = containerRecipeArn }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder = apply { this.distributionConfigurationArn = distributionConfigurationArn }
        override fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder = apply { this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled }
        override fun imageRecipeArn(imageRecipeArn: String): FluentBuilder = apply { this.imageRecipeArn = imageRecipeArn }
        override fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder = apply { this.imageTestsConfiguration = imageTestsConfiguration }
        override fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder = apply { this.infrastructureConfigurationArn = infrastructureConfigurationArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun schedule(schedule: Schedule): FluentBuilder = apply { this.schedule = schedule }
        override fun status(status: PipelineStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
