// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateImageRecipeRequest private constructor(builder: BuilderImpl) {
    /**
     * Specify additional settings and launch scripts for your build instances.
     */
    val additionalInstanceConfiguration: AdditionalInstanceConfiguration? = builder.additionalInstanceConfiguration
    /**
     * The block device mappings of the image recipe.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The components of the image recipe.
     */
    val components: List<ComponentConfiguration>? = builder.components
    /**
     * The description of the image recipe.
     */
    val description: String? = builder.description
    /**
     * The name of the image recipe.
     */
    val name: String? = builder.name
    /**
     * The parent image of the image recipe. The value of the string can be the ARN of the parent
     * image or an AMI ID. The format for the ARN follows this example:
     * arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x.
     * You can provide the specific version that you want to use, or you can use a wildcard in
     * all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI,
     * and the AMI must be in the same Region in which you are using Image Builder.
     */
    val parentImage: String? = builder.parentImage
    /**
     * The semantic version of the image recipe. This version follows the semantic version syntax.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     */
    val semanticVersion: String? = builder.semanticVersion
    /**
     * The tags of the image recipe.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The working directory used during build and test workflows.
     */
    val workingDirectory: String? = builder.workingDirectory

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateImageRecipeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageRecipeRequest(")
        append("additionalInstanceConfiguration=$additionalInstanceConfiguration,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("description=$description,")
        append("name=$name,")
        append("parentImage=$parentImage,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInstanceConfiguration?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateImageRecipeRequest

        if (additionalInstanceConfiguration != other.additionalInstanceConfiguration) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (parentImage != other.parentImage) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateImageRecipeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateImageRecipeRequest
        /**
         * Specify additional settings and launch scripts for your build instances.
         */
        fun additionalInstanceConfiguration(additionalInstanceConfiguration: AdditionalInstanceConfiguration): FluentBuilder
        /**
         * The block device mappings of the image recipe.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The components of the image recipe.
         */
        fun components(components: List<ComponentConfiguration>): FluentBuilder
        /**
         * The description of the image recipe.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the image recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The parent image of the image recipe. The value of the string can be the ARN of the parent
         * image or an AMI ID. The format for the ARN follows this example:
         * arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x.
         * You can provide the specific version that you want to use, or you can use a wildcard in
         * all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI,
         * and the AMI must be in the same Region in which you are using Image Builder.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * The semantic version of the image recipe. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        fun semanticVersion(semanticVersion: String): FluentBuilder
        /**
         * The tags of the image recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The working directory used during build and test workflows.
         */
        fun workingDirectory(workingDirectory: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specify additional settings and launch scripts for your build instances.
         */
        var additionalInstanceConfiguration: AdditionalInstanceConfiguration?
        /**
         * The block device mappings of the image recipe.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The components of the image recipe.
         */
        var components: List<ComponentConfiguration>?
        /**
         * The description of the image recipe.
         */
        var description: String?
        /**
         * The name of the image recipe.
         */
        var name: String?
        /**
         * The parent image of the image recipe. The value of the string can be the ARN of the parent
         * image or an AMI ID. The format for the ARN follows this example:
         * arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x.
         * You can provide the specific version that you want to use, or you can use a wildcard in
         * all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI,
         * and the AMI must be in the same Region in which you are using Image Builder.
         */
        var parentImage: String?
        /**
         * The semantic version of the image recipe. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         */
        var semanticVersion: String?
        /**
         * The tags of the image recipe.
         */
        var tags: Map<String, String>?
        /**
         * The working directory used during build and test workflows.
         */
        var workingDirectory: String?

        fun build(): CreateImageRecipeRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration] inside the given [block]
         */
        fun additionalInstanceConfiguration(block: AdditionalInstanceConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.additionalInstanceConfiguration = AdditionalInstanceConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalInstanceConfiguration: AdditionalInstanceConfiguration? = null
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var clientToken: String? = null
        override var components: List<ComponentConfiguration>? = null
        override var description: String? = null
        override var name: String? = null
        override var parentImage: String? = null
        override var semanticVersion: String? = null
        override var tags: Map<String, String>? = null
        override var workingDirectory: String? = null

        constructor(x: CreateImageRecipeRequest) : this() {
            this.additionalInstanceConfiguration = x.additionalInstanceConfiguration
            this.blockDeviceMappings = x.blockDeviceMappings
            this.clientToken = x.clientToken
            this.components = x.components
            this.description = x.description
            this.name = x.name
            this.parentImage = x.parentImage
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.workingDirectory = x.workingDirectory
        }

        override fun build(): CreateImageRecipeRequest = CreateImageRecipeRequest(this)
        override fun additionalInstanceConfiguration(additionalInstanceConfiguration: AdditionalInstanceConfiguration): FluentBuilder = apply { this.additionalInstanceConfiguration = additionalInstanceConfiguration }
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun components(components: List<ComponentConfiguration>): FluentBuilder = apply { this.components = components }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun semanticVersion(semanticVersion: String): FluentBuilder = apply { this.semanticVersion = semanticVersion }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun workingDirectory(workingDirectory: String): FluentBuilder = apply { this.workingDirectory = workingDirectory }
    }
}
