// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateImageRequest private constructor(builder: BuilderImpl) {
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
     */
    val containerRecipeArn: String? = builder.containerRecipeArn
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that defines and
     * configures the outputs of your pipeline.
     */
    val distributionConfigurationArn: String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating
     * system (OS) version and package list. This information is used to enhance the overall
     * experience of using EC2 Image Builder. Enabled by default.
     */
    val enhancedImageMetadataEnabled: Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image recipe that defines how images are
     * configured, tested, and assessed.
     */
    val imageRecipeArn: String? = builder.imageRecipeArn
    /**
     * The image tests configuration of the image.
     */
    val imageTestsConfiguration: ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the
     * environment in which your image will be built and tested.
     */
    val infrastructureConfigurationArn: String? = builder.infrastructureConfigurationArn
    /**
     * The tags of the image.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageRequest(")
        append("clientToken=$clientToken,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateImageRequest

        if (clientToken != other.clientToken) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateImageRequest
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
         */
        fun containerRecipeArn(containerRecipeArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that defines and
         * configures the outputs of your pipeline.
         */
        fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image recipe that defines how images are
         * configured, tested, and assessed.
         */
        fun imageRecipeArn(imageRecipeArn: String): FluentBuilder
        /**
         * The image tests configuration of the image.
         */
        fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the
         * environment in which your image will be built and tested.
         */
        fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder
        /**
         * The tags of the image.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
         */
        var containerRecipeArn: String?
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that defines and
         * configures the outputs of your pipeline.
         */
        var distributionConfigurationArn: String?
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        var enhancedImageMetadataEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the image recipe that defines how images are
         * configured, tested, and assessed.
         */
        var imageRecipeArn: String?
        /**
         * The image tests configuration of the image.
         */
        var imageTestsConfiguration: ImageTestsConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the
         * environment in which your image will be built and tested.
         */
        var infrastructureConfigurationArn: String?
        /**
         * The tags of the image.
         */
        var tags: Map<String, String>?

        fun build(): CreateImageRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        fun imageTestsConfiguration(block: ImageTestsConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = ImageTestsConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var containerRecipeArn: String? = null
        override var distributionConfigurationArn: String? = null
        override var enhancedImageMetadataEnabled: Boolean? = null
        override var imageRecipeArn: String? = null
        override var imageTestsConfiguration: ImageTestsConfiguration? = null
        override var infrastructureConfigurationArn: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateImageRequest) : this() {
            this.clientToken = x.clientToken
            this.containerRecipeArn = x.containerRecipeArn
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipeArn = x.imageRecipeArn
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.tags = x.tags
        }

        override fun build(): CreateImageRequest = CreateImageRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun containerRecipeArn(containerRecipeArn: String): FluentBuilder = apply { this.containerRecipeArn = containerRecipeArn }
        override fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder = apply { this.distributionConfigurationArn = distributionConfigurationArn }
        override fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder = apply { this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled }
        override fun imageRecipeArn(imageRecipeArn: String): FluentBuilder = apply { this.imageRecipeArn = imageRecipeArn }
        override fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder = apply { this.imageTestsConfiguration = imageTestsConfiguration }
        override fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder = apply { this.infrastructureConfigurationArn = infrastructureConfigurationArn }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
