// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class CreateInfrastructureConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The description of the infrastructure configuration.
     */
    val description: String? = builder.description
    /**
     * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     */
    val instanceProfileName: String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration. You can specify one or more
     * instance types to use for this build. The service will pick one of these instance types based
     * on availability.
     */
    val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The key pair of the infrastructure configuration. This can be used to log on to and debug
     * the instance used to create your image.
     */
    val keyPair: String? = builder.keyPair
    /**
     * The logging configuration of the infrastructure configuration.
     */
    val logging: Logging? = builder.logging
    /**
     * The name of the infrastructure configuration.
     */
    val name: String? = builder.name
    /**
     * The tags attached to the resource created by Image Builder.
     */
    val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The SNS topic on which to send image build events.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags of the infrastructure configuration.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The terminate instance on failure setting of the infrastructure configuration. Set to
     * false if you want Image Builder to retain the instance used to configure your AMI if the build
     * or test phase of your workflow fails.
     */
    val terminateInstanceOnFailure: Boolean? = builder.terminateInstanceOnFailure

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateInfrastructureConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInfrastructureConfigurationRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("keyPair=$keyPair,")
        append("logging=$logging,")
        append("name=$name,")
        append("resourceTags=$resourceTags,")
        append("securityGroupIds=$securityGroupIds,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("terminateInstanceOnFailure=$terminateInstanceOnFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (terminateInstanceOnFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateInfrastructureConfigurationRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (keyPair != other.keyPair) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (resourceTags != other.resourceTags) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (terminateInstanceOnFailure != other.terminateInstanceOnFailure) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateInfrastructureConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateInfrastructureConfigurationRequest
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The description of the infrastructure configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         */
        fun instanceProfileName(instanceProfileName: String): FluentBuilder
        /**
         * The instance types of the infrastructure configuration. You can specify one or more
         * instance types to use for this build. The service will pick one of these instance types based
         * on availability.
         */
        fun instanceTypes(instanceTypes: List<String>): FluentBuilder
        /**
         * The key pair of the infrastructure configuration. This can be used to log on to and debug
         * the instance used to create your image.
         */
        fun keyPair(keyPair: String): FluentBuilder
        /**
         * The logging configuration of the infrastructure configuration.
         */
        fun logging(logging: Logging): FluentBuilder
        /**
         * The name of the infrastructure configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags attached to the resource created by Image Builder.
         */
        fun resourceTags(resourceTags: Map<String, String>): FluentBuilder
        /**
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The SNS topic on which to send image build events.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags of the infrastructure configuration.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The terminate instance on failure setting of the infrastructure configuration. Set to
         * false if you want Image Builder to retain the instance used to configure your AMI if the build
         * or test phase of your workflow fails.
         */
        fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The description of the infrastructure configuration.
         */
        var description: String?
        /**
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         */
        var instanceProfileName: String?
        /**
         * The instance types of the infrastructure configuration. You can specify one or more
         * instance types to use for this build. The service will pick one of these instance types based
         * on availability.
         */
        var instanceTypes: List<String>?
        /**
         * The key pair of the infrastructure configuration. This can be used to log on to and debug
         * the instance used to create your image.
         */
        var keyPair: String?
        /**
         * The logging configuration of the infrastructure configuration.
         */
        var logging: Logging?
        /**
         * The name of the infrastructure configuration.
         */
        var name: String?
        /**
         * The tags attached to the resource created by Image Builder.
         */
        var resourceTags: Map<String, String>?
        /**
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         */
        var securityGroupIds: List<String>?
        /**
         * The SNS topic on which to send image build events.
         */
        var snsTopicArn: String?
        /**
         * The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.
         */
        var subnetId: String?
        /**
         * The tags of the infrastructure configuration.
         */
        var tags: Map<String, String>?
        /**
         * The terminate instance on failure setting of the infrastructure configuration. Set to
         * false if you want Image Builder to retain the instance used to configure your AMI if the build
         * or test phase of your workflow fails.
         */
        var terminateInstanceOnFailure: Boolean?

        fun build(): CreateInfrastructureConfigurationRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Logging] inside the given [block]
         */
        fun logging(block: Logging.DslBuilder.() -> kotlin.Unit) {
            this.logging = Logging.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var instanceProfileName: String? = null
        override var instanceTypes: List<String>? = null
        override var keyPair: String? = null
        override var logging: Logging? = null
        override var name: String? = null
        override var resourceTags: Map<String, String>? = null
        override var securityGroupIds: List<String>? = null
        override var snsTopicArn: String? = null
        override var subnetId: String? = null
        override var tags: Map<String, String>? = null
        override var terminateInstanceOnFailure: Boolean? = null

        constructor(x: CreateInfrastructureConfigurationRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.keyPair = x.keyPair
            this.logging = x.logging
            this.name = x.name
            this.resourceTags = x.resourceTags
            this.securityGroupIds = x.securityGroupIds
            this.snsTopicArn = x.snsTopicArn
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.terminateInstanceOnFailure = x.terminateInstanceOnFailure
        }

        override fun build(): CreateInfrastructureConfigurationRequest = CreateInfrastructureConfigurationRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun instanceProfileName(instanceProfileName: String): FluentBuilder = apply { this.instanceProfileName = instanceProfileName }
        override fun instanceTypes(instanceTypes: List<String>): FluentBuilder = apply { this.instanceTypes = instanceTypes }
        override fun keyPair(keyPair: String): FluentBuilder = apply { this.keyPair = keyPair }
        override fun logging(logging: Logging): FluentBuilder = apply { this.logging = logging }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun resourceTags(resourceTags: Map<String, String>): FluentBuilder = apply { this.resourceTags = resourceTags }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder = apply { this.terminateInstanceOnFailure = terminateInstanceOnFailure }
    }
}
