// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A distribution configuration.
 */
class DistributionConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    val arn: String? = builder.arn
    /**
     * The date on which this distribution configuration was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The date on which this distribution configuration was last updated.
     */
    val dateUpdated: String? = builder.dateUpdated
    /**
     * The description of the distribution configuration.
     */
    val description: String? = builder.description
    /**
     * The distribution objects that apply Region-specific
     * settings for the deployment of the image to targeted Regions.
     */
    val distributions: List<Distribution>? = builder.distributions
    /**
     * The name of the distribution configuration.
     */
    val name: String? = builder.name
    /**
     * The tags of the distribution configuration.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The maximum duration in minutes for this distribution configuration.
     */
    val timeoutMinutes: Int? = builder.timeoutMinutes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DistributionConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionConfiguration(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("distributions=$distributions,")
        append("name=$name,")
        append("tags=$tags,")
        append("timeoutMinutes=$timeoutMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DistributionConfiguration

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (distributions != other.distributions) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (timeoutMinutes != other.timeoutMinutes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DistributionConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DistributionConfiguration
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which this distribution configuration was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The date on which this distribution configuration was last updated.
         */
        fun dateUpdated(dateUpdated: String): FluentBuilder
        /**
         * The description of the distribution configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The distribution objects that apply Region-specific
         * settings for the deployment of the image to targeted Regions.
         */
        fun distributions(distributions: List<Distribution>): FluentBuilder
        /**
         * The name of the distribution configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags of the distribution configuration.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The maximum duration in minutes for this distribution configuration.
         */
        fun timeoutMinutes(timeoutMinutes: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         */
        var arn: String?
        /**
         * The date on which this distribution configuration was created.
         */
        var dateCreated: String?
        /**
         * The date on which this distribution configuration was last updated.
         */
        var dateUpdated: String?
        /**
         * The description of the distribution configuration.
         */
        var description: String?
        /**
         * The distribution objects that apply Region-specific
         * settings for the deployment of the image to targeted Regions.
         */
        var distributions: List<Distribution>?
        /**
         * The name of the distribution configuration.
         */
        var name: String?
        /**
         * The tags of the distribution configuration.
         */
        var tags: Map<String, String>?
        /**
         * The maximum duration in minutes for this distribution configuration.
         */
        var timeoutMinutes: Int?

        fun build(): DistributionConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var dateUpdated: String? = null
        override var description: String? = null
        override var distributions: List<Distribution>? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null
        override var timeoutMinutes: Int? = null

        constructor(x: DistributionConfiguration) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.distributions = x.distributions
            this.name = x.name
            this.tags = x.tags
            this.timeoutMinutes = x.timeoutMinutes
        }

        override fun build(): DistributionConfiguration = DistributionConfiguration(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateUpdated(dateUpdated: String): FluentBuilder = apply { this.dateUpdated = dateUpdated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun distributions(distributions: List<Distribution>): FluentBuilder = apply { this.distributions = distributions }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun timeoutMinutes(timeoutMinutes: Int): FluentBuilder = apply { this.timeoutMinutes = timeoutMinutes }
    }
}
