// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A high-level overview of a distribution configuration.
 */
class DistributionConfigurationSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    val arn: String? = builder.arn
    /**
     * The date on which the distribution configuration was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The date on which the distribution configuration was updated.
     */
    val dateUpdated: String? = builder.dateUpdated
    /**
     * The description of the distribution configuration.
     */
    val description: String? = builder.description
    /**
     * The name of the distribution configuration.
     */
    val name: String? = builder.name
    /**
     * A list of Regions where the container image is distributed to.
     */
    val regions: List<String>? = builder.regions
    /**
     * The tags associated with the distribution configuration.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DistributionConfigurationSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionConfigurationSummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("name=$name,")
        append("regions=$regions,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DistributionConfigurationSummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (regions != other.regions) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DistributionConfigurationSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DistributionConfigurationSummary
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which the distribution configuration was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The date on which the distribution configuration was updated.
         */
        fun dateUpdated(dateUpdated: String): FluentBuilder
        /**
         * The description of the distribution configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the distribution configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * A list of Regions where the container image is distributed to.
         */
        fun regions(regions: List<String>): FluentBuilder
        /**
         * The tags associated with the distribution configuration.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         */
        var arn: String?
        /**
         * The date on which the distribution configuration was created.
         */
        var dateCreated: String?
        /**
         * The date on which the distribution configuration was updated.
         */
        var dateUpdated: String?
        /**
         * The description of the distribution configuration.
         */
        var description: String?
        /**
         * The name of the distribution configuration.
         */
        var name: String?
        /**
         * A list of Regions where the container image is distributed to.
         */
        var regions: List<String>?
        /**
         * The tags associated with the distribution configuration.
         */
        var tags: Map<String, String>?

        fun build(): DistributionConfigurationSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var dateUpdated: String? = null
        override var description: String? = null
        override var name: String? = null
        override var regions: List<String>? = null
        override var tags: Map<String, String>? = null

        constructor(x: DistributionConfigurationSummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.name = x.name
            this.regions = x.regions
            this.tags = x.tags
        }

        override fun build(): DistributionConfigurationSummary = DistributionConfigurationSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateUpdated(dateUpdated: String): FluentBuilder = apply { this.dateUpdated = dateUpdated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun regions(regions: List<String>): FluentBuilder = apply { this.regions = regions }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
