// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Amazon EBS-specific block device mapping specifications.
 */
class EbsInstanceBlockDeviceSpecification private constructor(builder: BuilderImpl) {
    /**
     * Use to configure delete on termination of the associated device.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * Use to configure device encryption.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * Use to configure device IOPS.
     */
    val iops: Int? = builder.iops
    /**
     * Use to configure the KMS key to use when encrypting the device.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The snapshot that defines the device contents.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * Use to override the device's volume size.
     */
    val volumeSize: Int? = builder.volumeSize
    /**
     * Use to override the device's volume type.
     */
    val volumeType: EbsVolumeType? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EbsInstanceBlockDeviceSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EbsInstanceBlockDeviceSpecification(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotId=$snapshotId,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EbsInstanceBlockDeviceSpecification

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotId != other.snapshotId) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EbsInstanceBlockDeviceSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EbsInstanceBlockDeviceSpecification
        /**
         * Use to configure delete on termination of the associated device.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * Use to configure device encryption.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * Use to configure device IOPS.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * Use to configure the KMS key to use when encrypting the device.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The snapshot that defines the device contents.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * Use to override the device's volume size.
         */
        fun volumeSize(volumeSize: Int): FluentBuilder
        /**
         * Use to override the device's volume type.
         */
        fun volumeType(volumeType: EbsVolumeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use to configure delete on termination of the associated device.
         */
        var deleteOnTermination: Boolean?
        /**
         * Use to configure device encryption.
         */
        var encrypted: Boolean?
        /**
         * Use to configure device IOPS.
         */
        var iops: Int?
        /**
         * Use to configure the KMS key to use when encrypting the device.
         */
        var kmsKeyId: String?
        /**
         * The snapshot that defines the device contents.
         */
        var snapshotId: String?
        /**
         * Use to override the device's volume size.
         */
        var volumeSize: Int?
        /**
         * Use to override the device's volume type.
         */
        var volumeType: EbsVolumeType?

        fun build(): EbsInstanceBlockDeviceSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deleteOnTermination: Boolean? = null
        override var encrypted: Boolean? = null
        override var iops: Int? = null
        override var kmsKeyId: String? = null
        override var snapshotId: String? = null
        override var volumeSize: Int? = null
        override var volumeType: EbsVolumeType? = null

        constructor(x: EbsInstanceBlockDeviceSpecification) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.snapshotId = x.snapshotId
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        override fun build(): EbsInstanceBlockDeviceSpecification = EbsInstanceBlockDeviceSpecification(this)
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun volumeSize(volumeSize: Int): FluentBuilder = apply { this.volumeSize = volumeSize }
        override fun volumeType(volumeType: EbsVolumeType): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
