// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An Image Builder image. You must specify exactly one recipe for the image – either
 * a container recipe (containerRecipe), which creates a container
 * image, or an image recipe (imageRecipe), which creates an AMI.
 */
class Image private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the image.
     * Semantic versioning is included in each object's Amazon Resource Name (ARN),
     * at the level that applies to that object as follows:
     * <ol>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
     * either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </ol>
     */
    val arn: String? = builder.arn
    /**
     * The recipe that is used to create an Image Builder container image.
     */
    val containerRecipe: ContainerRecipe? = builder.containerRecipe
    /**
     * The date on which this image was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The distribution configuration used when creating this image.
     */
    val distributionConfiguration: DistributionConfiguration? = builder.distributionConfiguration
    /**
     * Collects additional information about the image being created, including the operating
     * system (OS) version and package list. This information is used to enhance the overall
     * experience of using EC2 Image Builder. Enabled by default.
     */
    val enhancedImageMetadataEnabled: Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The image recipe used when creating the image.
     */
    val imageRecipe: ImageRecipe? = builder.imageRecipe
    /**
     * The image tests configuration used when creating this image.
     */
    val imageTestsConfiguration: ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The infrastructure used when creating this image.
     */
    val infrastructureConfiguration: InfrastructureConfiguration? = builder.infrastructureConfiguration
    /**
     * The name of the image.
     */
    val name: String? = builder.name
    /**
     * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
     * Microsoft Windows Server 2019.
     */
    val osVersion: String? = builder.osVersion
    /**
     * The output resources produced when creating this image.
     */
    val outputResources: OutputResources? = builder.outputResources
    /**
     * The platform of the image.
     */
    val platform: Platform? = builder.platform
    /**
     * The Amazon Resource Name (ARN) of the image pipeline that created this image.
     */
    val sourcePipelineArn: String? = builder.sourcePipelineArn
    /**
     * The name of the image pipeline that created this image.
     */
    val sourcePipelineName: String? = builder.sourcePipelineName
    /**
     * The state of the image.
     */
    val state: ImageState? = builder.state
    /**
     * The tags of the image.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether this is an AMI or container image.
     */
    val type: ImageType? = builder.type
    /**
     * The semantic version of the image.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Image = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("arn=$arn,")
        append("containerRecipe=$containerRecipe,")
        append("dateCreated=$dateCreated,")
        append("distributionConfiguration=$distributionConfiguration,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipe=$imageRecipe,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfiguration=$infrastructureConfiguration,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("outputResources=$outputResources,")
        append("platform=$platform,")
        append("sourcePipelineArn=$sourcePipelineArn,")
        append("sourcePipelineName=$sourcePipelineName,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (containerRecipe?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (distributionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipe?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (outputResources?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (sourcePipelineArn?.hashCode() ?: 0)
        result = 31 * result + (sourcePipelineName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Image

        if (arn != other.arn) return false
        if (containerRecipe != other.containerRecipe) return false
        if (dateCreated != other.dateCreated) return false
        if (distributionConfiguration != other.distributionConfiguration) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipe != other.imageRecipe) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfiguration != other.infrastructureConfiguration) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (outputResources != other.outputResources) return false
        if (platform != other.platform) return false
        if (sourcePipelineArn != other.sourcePipelineArn) return false
        if (sourcePipelineName != other.sourcePipelineName) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Image = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Image
        /**
         * The Amazon Resource Name (ARN) of the image.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The recipe that is used to create an Image Builder container image.
         */
        fun containerRecipe(containerRecipe: ContainerRecipe): FluentBuilder
        /**
         * The date on which this image was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The distribution configuration used when creating this image.
         */
        fun distributionConfiguration(distributionConfiguration: DistributionConfiguration): FluentBuilder
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder
        /**
         * The image recipe used when creating the image.
         */
        fun imageRecipe(imageRecipe: ImageRecipe): FluentBuilder
        /**
         * The image tests configuration used when creating this image.
         */
        fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder
        /**
         * The infrastructure used when creating this image.
         */
        fun infrastructureConfiguration(infrastructureConfiguration: InfrastructureConfiguration): FluentBuilder
        /**
         * The name of the image.
         */
        fun name(name: String): FluentBuilder
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        fun osVersion(osVersion: String): FluentBuilder
        /**
         * The output resources produced when creating this image.
         */
        fun outputResources(outputResources: OutputResources): FluentBuilder
        /**
         * The platform of the image.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that created this image.
         */
        fun sourcePipelineArn(sourcePipelineArn: String): FluentBuilder
        /**
         * The name of the image pipeline that created this image.
         */
        fun sourcePipelineName(sourcePipelineName: String): FluentBuilder
        /**
         * The state of the image.
         */
        fun state(state: ImageState): FluentBuilder
        /**
         * The tags of the image.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies whether this is an AMI or container image.
         */
        fun type(type: ImageType): FluentBuilder
        /**
         * The semantic version of the image.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the image.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        var arn: String?
        /**
         * The recipe that is used to create an Image Builder container image.
         */
        var containerRecipe: ContainerRecipe?
        /**
         * The date on which this image was created.
         */
        var dateCreated: String?
        /**
         * The distribution configuration used when creating this image.
         */
        var distributionConfiguration: DistributionConfiguration?
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        var enhancedImageMetadataEnabled: Boolean?
        /**
         * The image recipe used when creating the image.
         */
        var imageRecipe: ImageRecipe?
        /**
         * The image tests configuration used when creating this image.
         */
        var imageTestsConfiguration: ImageTestsConfiguration?
        /**
         * The infrastructure used when creating this image.
         */
        var infrastructureConfiguration: InfrastructureConfiguration?
        /**
         * The name of the image.
         */
        var name: String?
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        var osVersion: String?
        /**
         * The output resources produced when creating this image.
         */
        var outputResources: OutputResources?
        /**
         * The platform of the image.
         */
        var platform: Platform?
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that created this image.
         */
        var sourcePipelineArn: String?
        /**
         * The name of the image pipeline that created this image.
         */
        var sourcePipelineName: String?
        /**
         * The state of the image.
         */
        var state: ImageState?
        /**
         * The tags of the image.
         */
        var tags: Map<String, String>?
        /**
         * Specifies whether this is an AMI or container image.
         */
        var type: ImageType?
        /**
         * The semantic version of the image.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        var version: String?

        fun build(): Image
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe] inside the given [block]
         */
        fun containerRecipe(block: ContainerRecipe.DslBuilder.() -> kotlin.Unit) {
            this.containerRecipe = ContainerRecipe.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.DistributionConfiguration] inside the given [block]
         */
        fun distributionConfiguration(block: DistributionConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.distributionConfiguration = DistributionConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageRecipe] inside the given [block]
         */
        fun imageRecipe(block: ImageRecipe.DslBuilder.() -> kotlin.Unit) {
            this.imageRecipe = ImageRecipe.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        fun imageTestsConfiguration(block: ImageTestsConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = ImageTestsConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfiguration] inside the given [block]
         */
        fun infrastructureConfiguration(block: InfrastructureConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.infrastructureConfiguration = InfrastructureConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.OutputResources] inside the given [block]
         */
        fun outputResources(block: OutputResources.DslBuilder.() -> kotlin.Unit) {
            this.outputResources = OutputResources.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        fun state(block: ImageState.DslBuilder.() -> kotlin.Unit) {
            this.state = ImageState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var containerRecipe: ContainerRecipe? = null
        override var dateCreated: String? = null
        override var distributionConfiguration: DistributionConfiguration? = null
        override var enhancedImageMetadataEnabled: Boolean? = null
        override var imageRecipe: ImageRecipe? = null
        override var imageTestsConfiguration: ImageTestsConfiguration? = null
        override var infrastructureConfiguration: InfrastructureConfiguration? = null
        override var name: String? = null
        override var osVersion: String? = null
        override var outputResources: OutputResources? = null
        override var platform: Platform? = null
        override var sourcePipelineArn: String? = null
        override var sourcePipelineName: String? = null
        override var state: ImageState? = null
        override var tags: Map<String, String>? = null
        override var type: ImageType? = null
        override var version: String? = null

        constructor(x: Image) : this() {
            this.arn = x.arn
            this.containerRecipe = x.containerRecipe
            this.dateCreated = x.dateCreated
            this.distributionConfiguration = x.distributionConfiguration
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipe = x.imageRecipe
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfiguration = x.infrastructureConfiguration
            this.name = x.name
            this.osVersion = x.osVersion
            this.outputResources = x.outputResources
            this.platform = x.platform
            this.sourcePipelineArn = x.sourcePipelineArn
            this.sourcePipelineName = x.sourcePipelineName
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        override fun build(): Image = Image(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun containerRecipe(containerRecipe: ContainerRecipe): FluentBuilder = apply { this.containerRecipe = containerRecipe }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun distributionConfiguration(distributionConfiguration: DistributionConfiguration): FluentBuilder = apply { this.distributionConfiguration = distributionConfiguration }
        override fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder = apply { this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled }
        override fun imageRecipe(imageRecipe: ImageRecipe): FluentBuilder = apply { this.imageRecipe = imageRecipe }
        override fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder = apply { this.imageTestsConfiguration = imageTestsConfiguration }
        override fun infrastructureConfiguration(infrastructureConfiguration: InfrastructureConfiguration): FluentBuilder = apply { this.infrastructureConfiguration = infrastructureConfiguration }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun osVersion(osVersion: String): FluentBuilder = apply { this.osVersion = osVersion }
        override fun outputResources(outputResources: OutputResources): FluentBuilder = apply { this.outputResources = outputResources }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun sourcePipelineArn(sourcePipelineArn: String): FluentBuilder = apply { this.sourcePipelineArn = sourcePipelineArn }
        override fun sourcePipelineName(sourcePipelineName: String): FluentBuilder = apply { this.sourcePipelineName = sourcePipelineName }
        override fun state(state: ImageState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ImageType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
