// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Details of an image pipeline.
 */
class ImagePipeline private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the image pipeline.
     */
    val arn: String? = builder.arn
    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    val containerRecipeArn: String? = builder.containerRecipeArn
    /**
     * The date on which this image pipeline was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The date on which this image pipeline was last run.
     */
    val dateLastRun: String? = builder.dateLastRun
    /**
     * The date on which this image pipeline will next be run.
     */
    val dateNextRun: String? = builder.dateNextRun
    /**
     * The date on which this image pipeline was last updated.
     */
    val dateUpdated: String? = builder.dateUpdated
    /**
     * The description of the image pipeline.
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this
     * image pipeline.
     */
    val distributionConfigurationArn: String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating
     * system (OS) version and package list. This information is used to enhance the overall
     * experience of using EC2 Image Builder. Enabled by default.
     */
    val enhancedImageMetadataEnabled: Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image recipe associated with this image
     * pipeline.
     */
    val imageRecipeArn: String? = builder.imageRecipeArn
    /**
     * The image tests configuration of the image pipeline.
     */
    val imageTestsConfiguration: ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
     * image pipeline.
     */
    val infrastructureConfigurationArn: String? = builder.infrastructureConfigurationArn
    /**
     * The name of the image pipeline.
     */
    val name: String? = builder.name
    /**
     * The platform of the image pipeline.
     */
    val platform: Platform? = builder.platform
    /**
     * The schedule of the image pipeline.
     */
    val schedule: Schedule? = builder.schedule
    /**
     * The status of the image pipeline.
     */
    val status: PipelineStatus? = builder.status
    /**
     * The tags of this image pipeline.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImagePipeline = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImagePipeline(")
        append("arn=$arn,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("dateCreated=$dateCreated,")
        append("dateLastRun=$dateLastRun,")
        append("dateNextRun=$dateNextRun,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("name=$name,")
        append("platform=$platform,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateLastRun?.hashCode() ?: 0)
        result = 31 * result + (dateNextRun?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImagePipeline

        if (arn != other.arn) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateLastRun != other.dateLastRun) return false
        if (dateNextRun != other.dateNextRun) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImagePipeline = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImagePipeline
        /**
         * The Amazon Resource Name (ARN) of the image pipeline.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         */
        fun containerRecipeArn(containerRecipeArn: String): FluentBuilder
        /**
         * The date on which this image pipeline was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The date on which this image pipeline was last run.
         */
        fun dateLastRun(dateLastRun: String): FluentBuilder
        /**
         * The date on which this image pipeline will next be run.
         */
        fun dateNextRun(dateNextRun: String): FluentBuilder
        /**
         * The date on which this image pipeline was last updated.
         */
        fun dateUpdated(dateUpdated: String): FluentBuilder
        /**
         * The description of the image pipeline.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration associated with this
         * image pipeline.
         */
        fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image recipe associated with this image
         * pipeline.
         */
        fun imageRecipeArn(imageRecipeArn: String): FluentBuilder
        /**
         * The image tests configuration of the image pipeline.
         */
        fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
         * image pipeline.
         */
        fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder
        /**
         * The name of the image pipeline.
         */
        fun name(name: String): FluentBuilder
        /**
         * The platform of the image pipeline.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The schedule of the image pipeline.
         */
        fun schedule(schedule: Schedule): FluentBuilder
        /**
         * The status of the image pipeline.
         */
        fun status(status: PipelineStatus): FluentBuilder
        /**
         * The tags of this image pipeline.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the image pipeline.
         */
        var arn: String?
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         */
        var containerRecipeArn: String?
        /**
         * The date on which this image pipeline was created.
         */
        var dateCreated: String?
        /**
         * The date on which this image pipeline was last run.
         */
        var dateLastRun: String?
        /**
         * The date on which this image pipeline will next be run.
         */
        var dateNextRun: String?
        /**
         * The date on which this image pipeline was last updated.
         */
        var dateUpdated: String?
        /**
         * The description of the image pipeline.
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration associated with this
         * image pipeline.
         */
        var distributionConfigurationArn: String?
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        var enhancedImageMetadataEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the image recipe associated with this image
         * pipeline.
         */
        var imageRecipeArn: String?
        /**
         * The image tests configuration of the image pipeline.
         */
        var imageTestsConfiguration: ImageTestsConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
         * image pipeline.
         */
        var infrastructureConfigurationArn: String?
        /**
         * The name of the image pipeline.
         */
        var name: String?
        /**
         * The platform of the image pipeline.
         */
        var platform: Platform?
        /**
         * The schedule of the image pipeline.
         */
        var schedule: Schedule?
        /**
         * The status of the image pipeline.
         */
        var status: PipelineStatus?
        /**
         * The tags of this image pipeline.
         */
        var tags: Map<String, String>?

        fun build(): ImagePipeline
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        fun imageTestsConfiguration(block: ImageTestsConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = ImageTestsConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Schedule] inside the given [block]
         */
        fun schedule(block: Schedule.DslBuilder.() -> kotlin.Unit) {
            this.schedule = Schedule.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var containerRecipeArn: String? = null
        override var dateCreated: String? = null
        override var dateLastRun: String? = null
        override var dateNextRun: String? = null
        override var dateUpdated: String? = null
        override var description: String? = null
        override var distributionConfigurationArn: String? = null
        override var enhancedImageMetadataEnabled: Boolean? = null
        override var imageRecipeArn: String? = null
        override var imageTestsConfiguration: ImageTestsConfiguration? = null
        override var infrastructureConfigurationArn: String? = null
        override var name: String? = null
        override var platform: Platform? = null
        override var schedule: Schedule? = null
        override var status: PipelineStatus? = null
        override var tags: Map<String, String>? = null

        constructor(x: ImagePipeline) : this() {
            this.arn = x.arn
            this.containerRecipeArn = x.containerRecipeArn
            this.dateCreated = x.dateCreated
            this.dateLastRun = x.dateLastRun
            this.dateNextRun = x.dateNextRun
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipeArn = x.imageRecipeArn
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.name = x.name
            this.platform = x.platform
            this.schedule = x.schedule
            this.status = x.status
            this.tags = x.tags
        }

        override fun build(): ImagePipeline = ImagePipeline(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun containerRecipeArn(containerRecipeArn: String): FluentBuilder = apply { this.containerRecipeArn = containerRecipeArn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateLastRun(dateLastRun: String): FluentBuilder = apply { this.dateLastRun = dateLastRun }
        override fun dateNextRun(dateNextRun: String): FluentBuilder = apply { this.dateNextRun = dateNextRun }
        override fun dateUpdated(dateUpdated: String): FluentBuilder = apply { this.dateUpdated = dateUpdated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder = apply { this.distributionConfigurationArn = distributionConfigurationArn }
        override fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder = apply { this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled }
        override fun imageRecipeArn(imageRecipeArn: String): FluentBuilder = apply { this.imageRecipeArn = imageRecipeArn }
        override fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder = apply { this.imageTestsConfiguration = imageTestsConfiguration }
        override fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder = apply { this.infrastructureConfigurationArn = infrastructureConfigurationArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun schedule(schedule: Schedule): FluentBuilder = apply { this.schedule = schedule }
        override fun status(status: PipelineStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
