// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An image recipe.
 */
class ImageRecipe private constructor(builder: BuilderImpl) {
    /**
     * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
     * build and test your image configuration. Instance configuration adds a layer
     * of control over those instances. You can define settings and add scripts to
     * run when an instance is launched from your AMI.
     */
    val additionalInstanceConfiguration: AdditionalInstanceConfiguration? = builder.additionalInstanceConfiguration
    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    val arn: String? = builder.arn
    /**
     * The block device mappings to apply when creating images from this recipe.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The components of the image recipe.
     */
    val components: List<ComponentConfiguration>? = builder.components
    /**
     * The date on which this image recipe was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The description of the image recipe.
     */
    val description: String? = builder.description
    /**
     * The name of the image recipe.
     */
    val name: String? = builder.name
    /**
     * The owner of the image recipe.
     */
    val owner: String? = builder.owner
    /**
     * The parent image of the image recipe.
     */
    val parentImage: String? = builder.parentImage
    /**
     * The platform of the image recipe.
     */
    val platform: Platform? = builder.platform
    /**
     * The tags of the image recipe.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies which type of image is created by the recipe - an AMI or a
     * container image.
     */
    val type: ImageType? = builder.type
    /**
     * The version of the image recipe.
     */
    val version: String? = builder.version
    /**
     * The working directory to be used during build and test workflows.
     */
    val workingDirectory: String? = builder.workingDirectory

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImageRecipe = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImageRecipe(")
        append("additionalInstanceConfiguration=$additionalInstanceConfiguration,")
        append("arn=$arn,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("components=$components,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInstanceConfiguration?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImageRecipe

        if (additionalInstanceConfiguration != other.additionalInstanceConfiguration) return false
        if (arn != other.arn) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (components != other.components) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImageRecipe = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImageRecipe
        /**
         * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
         * build and test your image configuration. Instance configuration adds a layer
         * of control over those instances. You can define settings and add scripts to
         * run when an instance is launched from your AMI.
         */
        fun additionalInstanceConfiguration(additionalInstanceConfiguration: AdditionalInstanceConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The block device mappings to apply when creating images from this recipe.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * The components of the image recipe.
         */
        fun components(components: List<ComponentConfiguration>): FluentBuilder
        /**
         * The date on which this image recipe was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The description of the image recipe.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the image recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the image recipe.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The parent image of the image recipe.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * The platform of the image recipe.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The tags of the image recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies which type of image is created by the recipe - an AMI or a
         * container image.
         */
        fun type(type: ImageType): FluentBuilder
        /**
         * The version of the image recipe.
         */
        fun version(version: String): FluentBuilder
        /**
         * The working directory to be used during build and test workflows.
         */
        fun workingDirectory(workingDirectory: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
         * build and test your image configuration. Instance configuration adds a layer
         * of control over those instances. You can define settings and add scripts to
         * run when an instance is launched from your AMI.
         */
        var additionalInstanceConfiguration: AdditionalInstanceConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         */
        var arn: String?
        /**
         * The block device mappings to apply when creating images from this recipe.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * The components of the image recipe.
         */
        var components: List<ComponentConfiguration>?
        /**
         * The date on which this image recipe was created.
         */
        var dateCreated: String?
        /**
         * The description of the image recipe.
         */
        var description: String?
        /**
         * The name of the image recipe.
         */
        var name: String?
        /**
         * The owner of the image recipe.
         */
        var owner: String?
        /**
         * The parent image of the image recipe.
         */
        var parentImage: String?
        /**
         * The platform of the image recipe.
         */
        var platform: Platform?
        /**
         * The tags of the image recipe.
         */
        var tags: Map<String, String>?
        /**
         * Specifies which type of image is created by the recipe - an AMI or a
         * container image.
         */
        var type: ImageType?
        /**
         * The version of the image recipe.
         */
        var version: String?
        /**
         * The working directory to be used during build and test workflows.
         */
        var workingDirectory: String?

        fun build(): ImageRecipe
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.AdditionalInstanceConfiguration] inside the given [block]
         */
        fun additionalInstanceConfiguration(block: AdditionalInstanceConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.additionalInstanceConfiguration = AdditionalInstanceConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalInstanceConfiguration: AdditionalInstanceConfiguration? = null
        override var arn: String? = null
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var components: List<ComponentConfiguration>? = null
        override var dateCreated: String? = null
        override var description: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var parentImage: String? = null
        override var platform: Platform? = null
        override var tags: Map<String, String>? = null
        override var type: ImageType? = null
        override var version: String? = null
        override var workingDirectory: String? = null

        constructor(x: ImageRecipe) : this() {
            this.additionalInstanceConfiguration = x.additionalInstanceConfiguration
            this.arn = x.arn
            this.blockDeviceMappings = x.blockDeviceMappings
            this.components = x.components
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
            this.workingDirectory = x.workingDirectory
        }

        override fun build(): ImageRecipe = ImageRecipe(this)
        override fun additionalInstanceConfiguration(additionalInstanceConfiguration: AdditionalInstanceConfiguration): FluentBuilder = apply { this.additionalInstanceConfiguration = additionalInstanceConfiguration }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun components(components: List<ComponentConfiguration>): FluentBuilder = apply { this.components = components }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ImageType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
        override fun workingDirectory(workingDirectory: String): FluentBuilder = apply { this.workingDirectory = workingDirectory }
    }
}
