// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A summary of an image recipe.
 */
class ImageRecipeSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    val arn: String? = builder.arn
    /**
     * The date on which this image recipe was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The name of the image recipe.
     */
    val name: String? = builder.name
    /**
     * The owner of the image recipe.
     */
    val owner: String? = builder.owner
    /**
     * The parent image of the image recipe.
     */
    val parentImage: String? = builder.parentImage
    /**
     * The platform of the image recipe.
     */
    val platform: Platform? = builder.platform
    /**
     * The tags of the image recipe.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImageRecipeSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImageRecipeSummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("name=$name,")
        append("owner=$owner,")
        append("parentImage=$parentImage,")
        append("platform=$platform,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImageRecipeSummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parentImage != other.parentImage) return false
        if (platform != other.platform) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImageRecipeSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImageRecipeSummary
        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which this image recipe was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The name of the image recipe.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the image recipe.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The parent image of the image recipe.
         */
        fun parentImage(parentImage: String): FluentBuilder
        /**
         * The platform of the image recipe.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The tags of the image recipe.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         */
        var arn: String?
        /**
         * The date on which this image recipe was created.
         */
        var dateCreated: String?
        /**
         * The name of the image recipe.
         */
        var name: String?
        /**
         * The owner of the image recipe.
         */
        var owner: String?
        /**
         * The parent image of the image recipe.
         */
        var parentImage: String?
        /**
         * The platform of the image recipe.
         */
        var platform: Platform?
        /**
         * The tags of the image recipe.
         */
        var tags: Map<String, String>?

        fun build(): ImageRecipeSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var name: String? = null
        override var owner: String? = null
        override var parentImage: String? = null
        override var platform: Platform? = null
        override var tags: Map<String, String>? = null

        constructor(x: ImageRecipeSummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.name = x.name
            this.owner = x.owner
            this.parentImage = x.parentImage
            this.platform = x.platform
            this.tags = x.tags
        }

        override fun build(): ImageRecipeSummary = ImageRecipeSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun parentImage(parentImage: String): FluentBuilder = apply { this.parentImage = parentImage }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
