// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * An image summary.
 */
class ImageSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the image.
     */
    val arn: String? = builder.arn
    /**
     * The date on which this image was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The name of the image.
     */
    val name: String? = builder.name
    /**
     * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
     * Microsoft Windows Server 2019.
     */
    val osVersion: String? = builder.osVersion
    /**
     * The output resources produced when creating this image.
     */
    val outputResources: OutputResources? = builder.outputResources
    /**
     * The owner of the image.
     */
    val owner: String? = builder.owner
    /**
     * The platform of the image.
     */
    val platform: Platform? = builder.platform
    /**
     * The state of the image.
     */
    val state: ImageState? = builder.state
    /**
     * The tags of the image.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether this is an AMI or container image.
     */
    val type: ImageType? = builder.type
    /**
     * The version of the image.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImageSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImageSummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("outputResources=$outputResources,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (outputResources?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImageSummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (outputResources != other.outputResources) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImageSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImageSummary
        /**
         * The Amazon Resource Name (ARN) of the image.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which this image was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The name of the image.
         */
        fun name(name: String): FluentBuilder
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        fun osVersion(osVersion: String): FluentBuilder
        /**
         * The output resources produced when creating this image.
         */
        fun outputResources(outputResources: OutputResources): FluentBuilder
        /**
         * The owner of the image.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The platform of the image.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The state of the image.
         */
        fun state(state: ImageState): FluentBuilder
        /**
         * The tags of the image.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies whether this is an AMI or container image.
         */
        fun type(type: ImageType): FluentBuilder
        /**
         * The version of the image.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the image.
         */
        var arn: String?
        /**
         * The date on which this image was created.
         */
        var dateCreated: String?
        /**
         * The name of the image.
         */
        var name: String?
        /**
         * The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        var osVersion: String?
        /**
         * The output resources produced when creating this image.
         */
        var outputResources: OutputResources?
        /**
         * The owner of the image.
         */
        var owner: String?
        /**
         * The platform of the image.
         */
        var platform: Platform?
        /**
         * The state of the image.
         */
        var state: ImageState?
        /**
         * The tags of the image.
         */
        var tags: Map<String, String>?
        /**
         * Specifies whether this is an AMI or container image.
         */
        var type: ImageType?
        /**
         * The version of the image.
         */
        var version: String?

        fun build(): ImageSummary
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.OutputResources] inside the given [block]
         */
        fun outputResources(block: OutputResources.DslBuilder.() -> kotlin.Unit) {
            this.outputResources = OutputResources.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageState] inside the given [block]
         */
        fun state(block: ImageState.DslBuilder.() -> kotlin.Unit) {
            this.state = ImageState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var name: String? = null
        override var osVersion: String? = null
        override var outputResources: OutputResources? = null
        override var owner: String? = null
        override var platform: Platform? = null
        override var state: ImageState? = null
        override var tags: Map<String, String>? = null
        override var type: ImageType? = null
        override var version: String? = null

        constructor(x: ImageSummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.name = x.name
            this.osVersion = x.osVersion
            this.outputResources = x.outputResources
            this.owner = x.owner
            this.platform = x.platform
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        override fun build(): ImageSummary = ImageSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun osVersion(osVersion: String): FluentBuilder = apply { this.osVersion = osVersion }
        override fun outputResources(outputResources: OutputResources): FluentBuilder = apply { this.outputResources = outputResources }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun state(state: ImageState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ImageType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
