// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * The defining characteristics of a specific version of an Image Builder image.
 */
class ImageVersion private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
     * Semantic versioning is included in each object's Amazon Resource Name (ARN),
     * at the level that applies to that object as follows:
     * <ol>
     * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
     * either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     * </ol>
     */
    val arn: String? = builder.arn
    /**
     * The date on which this specific version of the Image Builder image was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The name of this specific version of an Image Builder image.
     */
    val name: String? = builder.name
    /**
     * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
     * Microsoft Windows Server 2019.
     */
    val osVersion: String? = builder.osVersion
    /**
     * The owner of the image version.
     */
    val owner: String? = builder.owner
    /**
     * The platform of the image version, for example "Windows" or "Linux".
     */
    val platform: Platform? = builder.platform
    /**
     * Specifies whether this image is an AMI or a container image.
     */
    val type: ImageType? = builder.type
    /**
     * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Assignment: For the first three nodes you can assign any positive integer value, including
     * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
     * build number, and that is not open for updates.
     * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
     * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
     * a date, such as 2021.01.01.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImageVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImageVersion(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("name=$name,")
        append("osVersion=$osVersion,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImageVersion

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (name != other.name) return false
        if (osVersion != other.osVersion) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImageVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImageVersion
        /**
         * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which this specific version of the Image Builder image was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The name of this specific version of an Image Builder image.
         */
        fun name(name: String): FluentBuilder
        /**
         * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        fun osVersion(osVersion: String): FluentBuilder
        /**
         * The owner of the image version.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The platform of the image version, for example "Windows" or "Linux".
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * Specifies whether this image is an AMI or a container image.
         */
        fun type(type: ImageType): FluentBuilder
        /**
         * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
         * Semantic versioning is included in each object's Amazon Resource Name (ARN),
         * at the level that applies to that object as follows:
         * <ol>
         * Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
         * either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         * </ol>
         */
        var arn: String?
        /**
         * The date on which this specific version of the Image Builder image was created.
         */
        var dateCreated: String?
        /**
         * The name of this specific version of an Image Builder image.
         */
        var name: String?
        /**
         * The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
         * Microsoft Windows Server 2019.
         */
        var osVersion: String?
        /**
         * The owner of the image version.
         */
        var owner: String?
        /**
         * The platform of the image version, for example "Windows" or "Linux".
         */
        var platform: Platform?
        /**
         * Specifies whether this image is an AMI or a container image.
         */
        var type: ImageType?
        /**
         * Details for a specific version of an Image Builder image. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Assignment: For the first three nodes you can assign any positive integer value, including
         * zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
         * build number, and that is not open for updates.
         * Patterns: You can use any numeric pattern that adheres to the assignment requirements for
         * the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         * a date, such as 2021.01.01.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        var version: String?

        fun build(): ImageVersion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var name: String? = null
        override var osVersion: String? = null
        override var owner: String? = null
        override var platform: Platform? = null
        override var type: ImageType? = null
        override var version: String? = null

        constructor(x: ImageVersion) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.name = x.name
            this.osVersion = x.osVersion
            this.owner = x.owner
            this.platform = x.platform
            this.type = x.type
            this.version = x.version
        }

        override fun build(): ImageVersion = ImageVersion(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun osVersion(osVersion: String): FluentBuilder = apply { this.osVersion = osVersion }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun type(type: ImageType): FluentBuilder = apply { this.type = type }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
