// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class ImportComponentRequest private constructor(builder: BuilderImpl) {
    /**
     * The change description of the component. Describes what change has been made in this
     * version, or what makes this version different from other versions of this component.
     */
    val changeDescription: String? = builder.changeDescription
    /**
     * The idempotency token of the component.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The data of the component. Used to specify the data inline. Either data or
     * uri can be used to specify the data within the component.
     */
    val data: String? = builder.data
    /**
     * The description of the component. Describes the contents of the component.
     */
    val description: String? = builder.description
    /**
     * The format of the resource that you want to import as a component.
     */
    val format: ComponentFormat? = builder.format
    /**
     * The ID of the KMS key that should be used to encrypt this component.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the component.
     */
    val name: String? = builder.name
    /**
     * The platform of the component.
     */
    val platform: Platform? = builder.platform
    /**
     * The semantic version of the component. This version follows the semantic version syntax.
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
     * You can assign values for the first three, and can filter on all of them.
     * Filtering: When you retrieve or reference a resource with a semantic version, you can use
     * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
     * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
     * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
     * automatically uses a wildcard for that, if applicable.
     */
    val semanticVersion: String? = builder.semanticVersion
    /**
     * The tags of the component.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of the component denotes whether the component is used to build the image, or only
     * to test it.
     */
    val type: ComponentType? = builder.type
    /**
     * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
     * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
     * quota. Either data or uri can be used to specify the data within the
     * component.
     */
    val uri: String? = builder.uri

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportComponentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportComponentRequest(")
        append("changeDescription=$changeDescription,")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("description=$description,")
        append("format=$format,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("platform=$platform,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("type=$type,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeDescription?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportComponentRequest

        if (changeDescription != other.changeDescription) return false
        if (clientToken != other.clientToken) return false
        if (data != other.data) return false
        if (description != other.description) return false
        if (format != other.format) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportComponentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportComponentRequest
        /**
         * The change description of the component. Describes what change has been made in this
         * version, or what makes this version different from other versions of this component.
         */
        fun changeDescription(changeDescription: String): FluentBuilder
        /**
         * The idempotency token of the component.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The data of the component. Used to specify the data inline. Either data or
         * uri can be used to specify the data within the component.
         */
        fun data(data: String): FluentBuilder
        /**
         * The description of the component. Describes the contents of the component.
         */
        fun description(description: String): FluentBuilder
        /**
         * The format of the resource that you want to import as a component.
         */
        fun format(format: ComponentFormat): FluentBuilder
        /**
         * The ID of the KMS key that should be used to encrypt this component.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun name(name: String): FluentBuilder
        /**
         * The platform of the component.
         */
        fun platform(platform: Platform): FluentBuilder
        /**
         * The semantic version of the component. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        fun semanticVersion(semanticVersion: String): FluentBuilder
        /**
         * The tags of the component.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The type of the component denotes whether the component is used to build the image, or only
         * to test it.
         */
        fun type(type: ComponentType): FluentBuilder
        /**
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
         * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
         * quota. Either data or uri can be used to specify the data within the
         * component.
         */
        fun uri(uri: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The change description of the component. Describes what change has been made in this
         * version, or what makes this version different from other versions of this component.
         */
        var changeDescription: String?
        /**
         * The idempotency token of the component.
         */
        var clientToken: String?
        /**
         * The data of the component. Used to specify the data inline. Either data or
         * uri can be used to specify the data within the component.
         */
        var data: String?
        /**
         * The description of the component. Describes the contents of the component.
         */
        var description: String?
        /**
         * The format of the resource that you want to import as a component.
         */
        var format: ComponentFormat?
        /**
         * The ID of the KMS key that should be used to encrypt this component.
         */
        var kmsKeyId: String?
        /**
         * The name of the component.
         */
        var name: String?
        /**
         * The platform of the component.
         */
        var platform: Platform?
        /**
         * The semantic version of the component. This version follows the semantic version syntax.
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
         * You can assign values for the first three, and can filter on all of them.
         * Filtering: When you retrieve or reference a resource with a semantic version, you can use
         * wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the
         * first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list
         * results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder
         * automatically uses a wildcard for that, if applicable.
         */
        var semanticVersion: String?
        /**
         * The tags of the component.
         */
        var tags: Map<String, String>?
        /**
         * The type of the component denotes whether the component is used to build the image, or only
         * to test it.
         */
        var type: ComponentType?
        /**
         * The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
         * access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
         * quota. Either data or uri can be used to specify the data within the
         * component.
         */
        var uri: String?

        fun build(): ImportComponentRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var changeDescription: String? = null
        override var clientToken: String? = null
        override var data: String? = null
        override var description: String? = null
        override var format: ComponentFormat? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var platform: Platform? = null
        override var semanticVersion: String? = null
        override var tags: Map<String, String>? = null
        override var type: ComponentType? = null
        override var uri: String? = null

        constructor(x: ImportComponentRequest) : this() {
            this.changeDescription = x.changeDescription
            this.clientToken = x.clientToken
            this.data = x.data
            this.description = x.description
            this.format = x.format
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.platform = x.platform
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.type = x.type
            this.uri = x.uri
        }

        override fun build(): ImportComponentRequest = ImportComponentRequest(this)
        override fun changeDescription(changeDescription: String): FluentBuilder = apply { this.changeDescription = changeDescription }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun data(data: String): FluentBuilder = apply { this.data = data }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun format(format: ComponentFormat): FluentBuilder = apply { this.format = format }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun platform(platform: Platform): FluentBuilder = apply { this.platform = platform }
        override fun semanticVersion(semanticVersion: String): FluentBuilder = apply { this.semanticVersion = semanticVersion }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: ComponentType): FluentBuilder = apply { this.type = type }
        override fun uri(uri: String): FluentBuilder = apply { this.uri = uri }
    }
}
