// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Details of the infrastructure configuration.
 */
class InfrastructureConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration.
     */
    val arn: String? = builder.arn
    /**
     * The date on which the infrastructure configuration was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The date on which the infrastructure configuration was last updated.
     */
    val dateUpdated: String? = builder.dateUpdated
    /**
     * The description of the infrastructure configuration.
     */
    val description: String? = builder.description
    /**
     * The instance profile of the infrastructure configuration.
     */
    val instanceProfileName: String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration.
     */
    val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The Amazon EC2 key pair of the infrastructure configuration.
     */
    val keyPair: String? = builder.keyPair
    /**
     * The logging configuration of the infrastructure configuration.
     */
    val logging: Logging? = builder.logging
    /**
     * The name of the infrastructure configuration.
     */
    val name: String? = builder.name
    /**
     * The tags attached to the resource created by Image Builder.
     */
    val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The security group IDs of the infrastructure configuration.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * The subnet ID of the infrastructure configuration.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags of the infrastructure configuration.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The terminate instance on failure configuration of the infrastructure
     * configuration.
     */
    val terminateInstanceOnFailure: Boolean? = builder.terminateInstanceOnFailure

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InfrastructureConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InfrastructureConfiguration(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("keyPair=$keyPair,")
        append("logging=$logging,")
        append("name=$name,")
        append("resourceTags=$resourceTags,")
        append("securityGroupIds=$securityGroupIds,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("terminateInstanceOnFailure=$terminateInstanceOnFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (terminateInstanceOnFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InfrastructureConfiguration

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (keyPair != other.keyPair) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (resourceTags != other.resourceTags) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (terminateInstanceOnFailure != other.terminateInstanceOnFailure) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InfrastructureConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InfrastructureConfiguration
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which the infrastructure configuration was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        fun dateUpdated(dateUpdated: String): FluentBuilder
        /**
         * The description of the infrastructure configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The instance profile of the infrastructure configuration.
         */
        fun instanceProfileName(instanceProfileName: String): FluentBuilder
        /**
         * The instance types of the infrastructure configuration.
         */
        fun instanceTypes(instanceTypes: List<String>): FluentBuilder
        /**
         * The Amazon EC2 key pair of the infrastructure configuration.
         */
        fun keyPair(keyPair: String): FluentBuilder
        /**
         * The logging configuration of the infrastructure configuration.
         */
        fun logging(logging: Logging): FluentBuilder
        /**
         * The name of the infrastructure configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags attached to the resource created by Image Builder.
         */
        fun resourceTags(resourceTags: Map<String, String>): FluentBuilder
        /**
         * The security group IDs of the infrastructure configuration.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * The subnet ID of the infrastructure configuration.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags of the infrastructure configuration.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The terminate instance on failure configuration of the infrastructure
         * configuration.
         */
        fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        var arn: String?
        /**
         * The date on which the infrastructure configuration was created.
         */
        var dateCreated: String?
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        var dateUpdated: String?
        /**
         * The description of the infrastructure configuration.
         */
        var description: String?
        /**
         * The instance profile of the infrastructure configuration.
         */
        var instanceProfileName: String?
        /**
         * The instance types of the infrastructure configuration.
         */
        var instanceTypes: List<String>?
        /**
         * The Amazon EC2 key pair of the infrastructure configuration.
         */
        var keyPair: String?
        /**
         * The logging configuration of the infrastructure configuration.
         */
        var logging: Logging?
        /**
         * The name of the infrastructure configuration.
         */
        var name: String?
        /**
         * The tags attached to the resource created by Image Builder.
         */
        var resourceTags: Map<String, String>?
        /**
         * The security group IDs of the infrastructure configuration.
         */
        var securityGroupIds: List<String>?
        /**
         * The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        var snsTopicArn: String?
        /**
         * The subnet ID of the infrastructure configuration.
         */
        var subnetId: String?
        /**
         * The tags of the infrastructure configuration.
         */
        var tags: Map<String, String>?
        /**
         * The terminate instance on failure configuration of the infrastructure
         * configuration.
         */
        var terminateInstanceOnFailure: Boolean?

        fun build(): InfrastructureConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Logging] inside the given [block]
         */
        fun logging(block: Logging.DslBuilder.() -> kotlin.Unit) {
            this.logging = Logging.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var dateUpdated: String? = null
        override var description: String? = null
        override var instanceProfileName: String? = null
        override var instanceTypes: List<String>? = null
        override var keyPair: String? = null
        override var logging: Logging? = null
        override var name: String? = null
        override var resourceTags: Map<String, String>? = null
        override var securityGroupIds: List<String>? = null
        override var snsTopicArn: String? = null
        override var subnetId: String? = null
        override var tags: Map<String, String>? = null
        override var terminateInstanceOnFailure: Boolean? = null

        constructor(x: InfrastructureConfiguration) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.keyPair = x.keyPair
            this.logging = x.logging
            this.name = x.name
            this.resourceTags = x.resourceTags
            this.securityGroupIds = x.securityGroupIds
            this.snsTopicArn = x.snsTopicArn
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.terminateInstanceOnFailure = x.terminateInstanceOnFailure
        }

        override fun build(): InfrastructureConfiguration = InfrastructureConfiguration(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateUpdated(dateUpdated: String): FluentBuilder = apply { this.dateUpdated = dateUpdated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun instanceProfileName(instanceProfileName: String): FluentBuilder = apply { this.instanceProfileName = instanceProfileName }
        override fun instanceTypes(instanceTypes: List<String>): FluentBuilder = apply { this.instanceTypes = instanceTypes }
        override fun keyPair(keyPair: String): FluentBuilder = apply { this.keyPair = keyPair }
        override fun logging(logging: Logging): FluentBuilder = apply { this.logging = logging }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun resourceTags(resourceTags: Map<String, String>): FluentBuilder = apply { this.resourceTags = resourceTags }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder = apply { this.terminateInstanceOnFailure = terminateInstanceOnFailure }
    }
}
