// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * The infrastructure used when building Amazon EC2 AMIs.
 */
class InfrastructureConfigurationSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration.
     */
    val arn: String? = builder.arn
    /**
     * The date on which the infrastructure configuration was created.
     */
    val dateCreated: String? = builder.dateCreated
    /**
     * The date on which the infrastructure configuration was last updated.
     */
    val dateUpdated: String? = builder.dateUpdated
    /**
     * The description of the infrastructure configuration.
     */
    val description: String? = builder.description
    /**
     * The instance profile of the infrastructure configuration.
     */
    val instanceProfileName: String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration.
     */
    val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The name of the infrastructure configuration.
     */
    val name: String? = builder.name
    /**
     * The tags attached to the image created by Image Builder.
     */
    val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The tags of the infrastructure configuration.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InfrastructureConfigurationSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InfrastructureConfigurationSummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("name=$name,")
        append("resourceTags=$resourceTags,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InfrastructureConfigurationSummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (name != other.name) return false
        if (resourceTags != other.resourceTags) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InfrastructureConfigurationSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InfrastructureConfigurationSummary
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date on which the infrastructure configuration was created.
         */
        fun dateCreated(dateCreated: String): FluentBuilder
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        fun dateUpdated(dateUpdated: String): FluentBuilder
        /**
         * The description of the infrastructure configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The instance profile of the infrastructure configuration.
         */
        fun instanceProfileName(instanceProfileName: String): FluentBuilder
        /**
         * The instance types of the infrastructure configuration.
         */
        fun instanceTypes(instanceTypes: List<String>): FluentBuilder
        /**
         * The name of the infrastructure configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags attached to the image created by Image Builder.
         */
        fun resourceTags(resourceTags: Map<String, String>): FluentBuilder
        /**
         * The tags of the infrastructure configuration.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration.
         */
        var arn: String?
        /**
         * The date on which the infrastructure configuration was created.
         */
        var dateCreated: String?
        /**
         * The date on which the infrastructure configuration was last updated.
         */
        var dateUpdated: String?
        /**
         * The description of the infrastructure configuration.
         */
        var description: String?
        /**
         * The instance profile of the infrastructure configuration.
         */
        var instanceProfileName: String?
        /**
         * The instance types of the infrastructure configuration.
         */
        var instanceTypes: List<String>?
        /**
         * The name of the infrastructure configuration.
         */
        var name: String?
        /**
         * The tags attached to the image created by Image Builder.
         */
        var resourceTags: Map<String, String>?
        /**
         * The tags of the infrastructure configuration.
         */
        var tags: Map<String, String>?

        fun build(): InfrastructureConfigurationSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var dateCreated: String? = null
        override var dateUpdated: String? = null
        override var description: String? = null
        override var instanceProfileName: String? = null
        override var instanceTypes: List<String>? = null
        override var name: String? = null
        override var resourceTags: Map<String, String>? = null
        override var tags: Map<String, String>? = null

        constructor(x: InfrastructureConfigurationSummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.name = x.name
            this.resourceTags = x.resourceTags
            this.tags = x.tags
        }

        override fun build(): InfrastructureConfigurationSummary = InfrastructureConfigurationSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun dateCreated(dateCreated: String): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateUpdated(dateUpdated: String): FluentBuilder = apply { this.dateUpdated = dateUpdated }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun instanceProfileName(instanceProfileName: String): FluentBuilder = apply { this.instanceProfileName = instanceProfileName }
        override fun instanceTypes(instanceTypes: List<String>): FluentBuilder = apply { this.instanceTypes = instanceTypes }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun resourceTags(resourceTags: Map<String, String>): FluentBuilder = apply { this.resourceTags = resourceTags }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
