// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Defines block device mappings for the instance used to configure your image.
 */
class InstanceBlockDeviceMapping private constructor(builder: BuilderImpl) {
    /**
     * The device to which these mappings apply.
     */
    val deviceName: String? = builder.deviceName
    /**
     * Use to manage Amazon EBS-specific configuration for this mapping.
     */
    val ebs: EbsInstanceBlockDeviceSpecification? = builder.ebs
    /**
     * Use to remove a mapping from the parent image.
     */
    val noDevice: String? = builder.noDevice
    /**
     * Use to manage instance ephemeral devices.
     */
    val virtualName: String? = builder.virtualName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceBlockDeviceMapping = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceBlockDeviceMapping(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceBlockDeviceMapping

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceBlockDeviceMapping = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceBlockDeviceMapping
        /**
         * The device to which these mappings apply.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * Use to manage Amazon EBS-specific configuration for this mapping.
         */
        fun ebs(ebs: EbsInstanceBlockDeviceSpecification): FluentBuilder
        /**
         * Use to remove a mapping from the parent image.
         */
        fun noDevice(noDevice: String): FluentBuilder
        /**
         * Use to manage instance ephemeral devices.
         */
        fun virtualName(virtualName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The device to which these mappings apply.
         */
        var deviceName: String?
        /**
         * Use to manage Amazon EBS-specific configuration for this mapping.
         */
        var ebs: EbsInstanceBlockDeviceSpecification?
        /**
         * Use to remove a mapping from the parent image.
         */
        var noDevice: String?
        /**
         * Use to manage instance ephemeral devices.
         */
        var virtualName: String?

        fun build(): InstanceBlockDeviceMapping
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification] inside the given [block]
         */
        fun ebs(block: EbsInstanceBlockDeviceSpecification.DslBuilder.() -> kotlin.Unit) {
            this.ebs = EbsInstanceBlockDeviceSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceName: String? = null
        override var ebs: EbsInstanceBlockDeviceSpecification? = null
        override var noDevice: String? = null
        override var virtualName: String? = null

        constructor(x: InstanceBlockDeviceMapping) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        override fun build(): InstanceBlockDeviceMapping = InstanceBlockDeviceMapping(this)
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun ebs(ebs: EbsInstanceBlockDeviceSpecification): FluentBuilder = apply { this.ebs = ebs }
        override fun noDevice(noDevice: String): FluentBuilder = apply { this.noDevice = noDevice }
        override fun virtualName(virtualName: String): FluentBuilder = apply { this.virtualName = virtualName }
    }
}
