// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Defines a custom source AMI and block device mapping configurations of an instance
 * used for building and testing container images.
 */
class InstanceConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Defines the block devices to attach for building an instance from this Image Builder AMI.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The AMI ID to use as the base image for a container build and test instance. If not specified,
     * Image Builder will use the appropriate ECS-optimized AMI as a base image.
     */
    val image: String? = builder.image

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceConfiguration(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("image=$image)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceConfiguration

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (image != other.image) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceConfiguration
        /**
         * Defines the block devices to attach for building an instance from this Image Builder AMI.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * The AMI ID to use as the base image for a container build and test instance. If not specified,
         * Image Builder will use the appropriate ECS-optimized AMI as a base image.
         */
        fun image(image: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Defines the block devices to attach for building an instance from this Image Builder AMI.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * The AMI ID to use as the base image for a container build and test instance. If not specified,
         * Image Builder will use the appropriate ECS-optimized AMI as a base image.
         */
        var image: String?

        fun build(): InstanceConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var image: String? = null

        constructor(x: InstanceConfiguration) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.image = x.image
        }

        override fun build(): InstanceConfiguration = InstanceConfiguration(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun image(image: String): FluentBuilder = apply { this.image = image }
    }
}
