// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Describes the configuration for a launch permission. The launch permission modification request is sent to the
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute
 * API on behalf of the user for each Region they have selected to distribute the AMI. To make an AMI public,
 * set the launch permission authorized accounts to all. See the examples for making an AMI public at
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute.
 */
class LaunchPermissionConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The name of the group.
     */
    val userGroups: List<String>? = builder.userGroups
    /**
     * The Amazon Web Services account ID.
     */
    val userIds: List<String>? = builder.userIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchPermissionConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchPermissionConfiguration(")
        append("userGroups=$userGroups,")
        append("userIds=$userIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = userGroups?.hashCode() ?: 0
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchPermissionConfiguration

        if (userGroups != other.userGroups) return false
        if (userIds != other.userIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchPermissionConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchPermissionConfiguration
        /**
         * The name of the group.
         */
        fun userGroups(userGroups: List<String>): FluentBuilder
        /**
         * The Amazon Web Services account ID.
         */
        fun userIds(userIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the group.
         */
        var userGroups: List<String>?
        /**
         * The Amazon Web Services account ID.
         */
        var userIds: List<String>?

        fun build(): LaunchPermissionConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var userGroups: List<String>? = null
        override var userIds: List<String>? = null

        constructor(x: LaunchPermissionConfiguration) : this() {
            this.userGroups = x.userGroups
            this.userIds = x.userIds
        }

        override fun build(): LaunchPermissionConfiguration = LaunchPermissionConfiguration(this)
        override fun userGroups(userGroups: List<String>): FluentBuilder = apply { this.userGroups = userGroups }
        override fun userIds(userIds: List<String>): FluentBuilder = apply { this.userIds = userIds }
    }
}
