// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Identifies an Amazon EC2 launch template to use for a specific account.
 */
class LaunchTemplateConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The account ID that this configuration applies to.
     */
    val accountId: String? = builder.accountId
    /**
     * Identifies the Amazon EC2 launch template to use.
     */
    val launchTemplateId: String? = builder.launchTemplateId
    /**
     * Set the specified Amazon EC2 launch template as the default launch template for the specified account.
     */
    val setDefaultVersion: Boolean = builder.setDefaultVersion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateConfiguration(")
        append("accountId=$accountId,")
        append("launchTemplateId=$launchTemplateId,")
        append("setDefaultVersion=$setDefaultVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateId?.hashCode() ?: 0)
        result = 31 * result + (setDefaultVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateConfiguration

        if (accountId != other.accountId) return false
        if (launchTemplateId != other.launchTemplateId) return false
        if (setDefaultVersion != other.setDefaultVersion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateConfiguration
        /**
         * The account ID that this configuration applies to.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * Identifies the Amazon EC2 launch template to use.
         */
        fun launchTemplateId(launchTemplateId: String): FluentBuilder
        /**
         * Set the specified Amazon EC2 launch template as the default launch template for the specified account.
         */
        fun setDefaultVersion(setDefaultVersion: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The account ID that this configuration applies to.
         */
        var accountId: String?
        /**
         * Identifies the Amazon EC2 launch template to use.
         */
        var launchTemplateId: String?
        /**
         * Set the specified Amazon EC2 launch template as the default launch template for the specified account.
         */
        var setDefaultVersion: Boolean

        fun build(): LaunchTemplateConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var launchTemplateId: String? = null
        override var setDefaultVersion: Boolean = false

        constructor(x: LaunchTemplateConfiguration) : this() {
            this.accountId = x.accountId
            this.launchTemplateId = x.launchTemplateId
            this.setDefaultVersion = x.setDefaultVersion
        }

        override fun build(): LaunchTemplateConfiguration = LaunchTemplateConfiguration(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun launchTemplateId(launchTemplateId: String): FluentBuilder = apply { this.launchTemplateId = launchTemplateId }
        override fun setDefaultVersion(setDefaultVersion: Boolean): FluentBuilder = apply { this.setDefaultVersion = setDefaultVersion }
    }
}
