// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class ListComponentsRequest private constructor(builder: BuilderImpl) {
    /**
     * Returns the list of component build versions for the specified name.
     */
    val byName: Boolean = builder.byName
    /**
     * Use the following filters to streamline results:
     * description
     * name
     * platform
     * supportedOsVersion
     * type
     * version
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum items to return in a request.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A token to specify where to start paginating. This is the NextToken from a previously
     * truncated response.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The owner defines which components you want to list. By default, this request will only
     * show components owned by your account. You can use this field to specify if you want to view
     * components owned by yourself, by Amazon, or those components that have been shared with you by
     * other customers.
     */
    val owner: Ownership? = builder.owner

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListComponentsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListComponentsRequest(")
        append("byName=$byName,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("owner=$owner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = byName.hashCode()
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListComponentsRequest

        if (byName != other.byName) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (owner != other.owner) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListComponentsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListComponentsRequest
        /**
         * Returns the list of component build versions for the specified name.
         */
        fun byName(byName: Boolean): FluentBuilder
        /**
         * Use the following filters to streamline results:
         * description
         * name
         * platform
         * supportedOsVersion
         * type
         * version
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum items to return in a request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token to specify where to start paginating. This is the NextToken from a previously
         * truncated response.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The owner defines which components you want to list. By default, this request will only
         * show components owned by your account. You can use this field to specify if you want to view
         * components owned by yourself, by Amazon, or those components that have been shared with you by
         * other customers.
         */
        fun owner(owner: Ownership): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Returns the list of component build versions for the specified name.
         */
        var byName: Boolean
        /**
         * Use the following filters to streamline results:
         * description
         * name
         * platform
         * supportedOsVersion
         * type
         * version
         */
        var filters: List<Filter>?
        /**
         * The maximum items to return in a request.
         */
        var maxResults: Int
        /**
         * A token to specify where to start paginating. This is the NextToken from a previously
         * truncated response.
         */
        var nextToken: String?
        /**
         * The owner defines which components you want to list. By default, this request will only
         * show components owned by your account. You can use this field to specify if you want to view
         * components owned by yourself, by Amazon, or those components that have been shared with you by
         * other customers.
         */
        var owner: Ownership?

        fun build(): ListComponentsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var byName: Boolean = false
        override var filters: List<Filter>? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var owner: Ownership? = null

        constructor(x: ListComponentsRequest) : this() {
            this.byName = x.byName
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.owner = x.owner
        }

        override fun build(): ListComponentsRequest = ListComponentsRequest(this)
        override fun byName(byName: Boolean): FluentBuilder = apply { this.byName = byName }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun owner(owner: Ownership): FluentBuilder = apply { this.owner = owner }
    }
}
