// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class ListContainerRecipesRequest private constructor(builder: BuilderImpl) {
    /**
     * Use the following filters to streamline results:
     * containerType
     * name
     * parentImage
     * platform
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in the list.
     */
    val maxResults: Int = builder.maxResults
    /**
     * Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.
     */
    val owner: Ownership? = builder.owner

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListContainerRecipesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListContainerRecipesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("owner=$owner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListContainerRecipesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (owner != other.owner) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListContainerRecipesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListContainerRecipesRequest
        /**
         * Use the following filters to streamline results:
         * containerType
         * name
         * parentImage
         * platform
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return in the list.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.
         */
        fun owner(owner: Ownership): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use the following filters to streamline results:
         * containerType
         * name
         * parentImage
         * platform
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return in the list.
         */
        var maxResults: Int
        /**
         * Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.
         */
        var nextToken: String?
        /**
         * Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.
         */
        var owner: Ownership?

        fun build(): ListContainerRecipesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filters: List<Filter>? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var owner: Ownership? = null

        constructor(x: ListContainerRecipesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.owner = x.owner
        }

        override fun build(): ListContainerRecipesRequest = ListContainerRecipesRequest(this)
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun owner(owner: Ownership): FluentBuilder = apply { this.owner = owner }
    }
}
