// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class ListImageBuildVersionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Use the following filters to streamline results:
     * name
     * osVersion
     * platform
     * type
     * version
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.
     */
    val imageVersionArn: String? = builder.imageVersionArn
    /**
     * The maximum items to return in a request.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A token to specify where to start paginating. This is the NextToken from a previously
     * truncated response.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListImageBuildVersionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListImageBuildVersionsRequest(")
        append("filters=$filters,")
        append("imageVersionArn=$imageVersionArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (imageVersionArn?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListImageBuildVersionsRequest

        if (filters != other.filters) return false
        if (imageVersionArn != other.imageVersionArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListImageBuildVersionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListImageBuildVersionsRequest
        /**
         * Use the following filters to streamline results:
         * name
         * osVersion
         * platform
         * type
         * version
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.
         */
        fun imageVersionArn(imageVersionArn: String): FluentBuilder
        /**
         * The maximum items to return in a request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token to specify where to start paginating. This is the NextToken from a previously
         * truncated response.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use the following filters to streamline results:
         * name
         * osVersion
         * platform
         * type
         * version
         */
        var filters: List<Filter>?
        /**
         * The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.
         */
        var imageVersionArn: String?
        /**
         * The maximum items to return in a request.
         */
        var maxResults: Int
        /**
         * A token to specify where to start paginating. This is the NextToken from a previously
         * truncated response.
         */
        var nextToken: String?

        fun build(): ListImageBuildVersionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filters: List<Filter>? = null
        override var imageVersionArn: String? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null

        constructor(x: ListImageBuildVersionsRequest) : this() {
            this.filters = x.filters
            this.imageVersionArn = x.imageVersionArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListImageBuildVersionsRequest = ListImageBuildVersionsRequest(this)
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun imageVersionArn(imageVersionArn: String): FluentBuilder = apply { this.imageVersionArn = imageVersionArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
