// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A schedule configures how often and when a pipeline will automatically create a new image.
 */
class Schedule private constructor(builder: BuilderImpl) {
    /**
     * The condition configures when the pipeline should trigger a new image build. When the
     * pipelineExecutionStartCondition is set to
     * EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE, and you use semantic version
     * filters on the source image or components in your image recipe, EC2 Image Builder will build a
     * new image only when there are new versions of the image or components in your recipe that
     * match the semantic version filter. When it is set to EXPRESSION_MATCH_ONLY, it
     * will build a new image every time the CRON expression matches the current time. For semantic
     * version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent in the  EC2 Image Builder API
     * Reference.
     */
    val pipelineExecutionStartCondition: PipelineExecutionStartCondition? = builder.pipelineExecutionStartCondition
    /**
     * The cron expression determines how often EC2 Image Builder evaluates your
     * pipelineExecutionStartCondition.
     * For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
     * expressions in EC2 Image Builder.
     */
    val scheduleExpression: String? = builder.scheduleExpression
    /**
     * The timezone that applies to the scheduling expression. For example, "Etc/UTC",
     * "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
     * timezone format. If not specified this defaults to UTC.
     */
    val timezone: String? = builder.timezone

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Schedule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Schedule(")
        append("pipelineExecutionStartCondition=$pipelineExecutionStartCondition,")
        append("scheduleExpression=$scheduleExpression,")
        append("timezone=$timezone)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pipelineExecutionStartCondition?.hashCode() ?: 0
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Schedule

        if (pipelineExecutionStartCondition != other.pipelineExecutionStartCondition) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (timezone != other.timezone) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Schedule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Schedule
        /**
         * The condition configures when the pipeline should trigger a new image build. When the
         * pipelineExecutionStartCondition is set to
         * EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE, and you use semantic version
         * filters on the source image or components in your image recipe, EC2 Image Builder will build a
         * new image only when there are new versions of the image or components in your recipe that
         * match the semantic version filter. When it is set to EXPRESSION_MATCH_ONLY, it
         * will build a new image every time the CRON expression matches the current time. For semantic
         * version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent in the  EC2 Image Builder API
         * Reference.
         */
        fun pipelineExecutionStartCondition(pipelineExecutionStartCondition: PipelineExecutionStartCondition): FluentBuilder
        /**
         * The cron expression determines how often EC2 Image Builder evaluates your
         * pipelineExecutionStartCondition.
         * For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
         * expressions in EC2 Image Builder.
         */
        fun scheduleExpression(scheduleExpression: String): FluentBuilder
        /**
         * The timezone that applies to the scheduling expression. For example, "Etc/UTC",
         * "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
         * timezone format. If not specified this defaults to UTC.
         */
        fun timezone(timezone: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The condition configures when the pipeline should trigger a new image build. When the
         * pipelineExecutionStartCondition is set to
         * EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE, and you use semantic version
         * filters on the source image or components in your image recipe, EC2 Image Builder will build a
         * new image only when there are new versions of the image or components in your recipe that
         * match the semantic version filter. When it is set to EXPRESSION_MATCH_ONLY, it
         * will build a new image every time the CRON expression matches the current time. For semantic
         * version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent in the  EC2 Image Builder API
         * Reference.
         */
        var pipelineExecutionStartCondition: PipelineExecutionStartCondition?
        /**
         * The cron expression determines how often EC2 Image Builder evaluates your
         * pipelineExecutionStartCondition.
         * For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
         * expressions in EC2 Image Builder.
         */
        var scheduleExpression: String?
        /**
         * The timezone that applies to the scheduling expression. For example, "Etc/UTC",
         * "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
         * timezone format. If not specified this defaults to UTC.
         */
        var timezone: String?

        fun build(): Schedule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var pipelineExecutionStartCondition: PipelineExecutionStartCondition? = null
        override var scheduleExpression: String? = null
        override var timezone: String? = null

        constructor(x: Schedule) : this() {
            this.pipelineExecutionStartCondition = x.pipelineExecutionStartCondition
            this.scheduleExpression = x.scheduleExpression
            this.timezone = x.timezone
        }

        override fun build(): Schedule = Schedule(this)
        override fun pipelineExecutionStartCondition(pipelineExecutionStartCondition: PipelineExecutionStartCondition): FluentBuilder = apply { this.pipelineExecutionStartCondition = pipelineExecutionStartCondition }
        override fun scheduleExpression(scheduleExpression: String): FluentBuilder = apply { this.scheduleExpression = scheduleExpression }
        override fun timezone(timezone: String): FluentBuilder = apply { this.timezone = timezone }
    }
}
