// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class UpdateImagePipelineRequest private constructor(builder: BuilderImpl) {
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the container pipeline to update.
     */
    val containerRecipeArn: String? = builder.containerRecipeArn
    /**
     * The description of the image pipeline.
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
     * configure and distribute images updated by this image pipeline.
     */
    val distributionConfigurationArn: String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating
     * system (OS) version and package list. This information is used to enhance the overall
     * experience of using EC2 Image Builder. Enabled by default.
     */
    val enhancedImageMetadataEnabled: Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image pipeline that you want to update.
     */
    val imagePipelineArn: String? = builder.imagePipelineArn
    /**
     * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
     * updated by this image pipeline.
     */
    val imageRecipeArn: String? = builder.imageRecipeArn
    /**
     * The image test configuration of the image pipeline.
     */
    val imageTestsConfiguration: ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
     * build images updated by this image pipeline.
     */
    val infrastructureConfigurationArn: String? = builder.infrastructureConfigurationArn
    /**
     * The schedule of the image pipeline.
     */
    val schedule: Schedule? = builder.schedule
    /**
     * The status of the image pipeline.
     */
    val status: PipelineStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateImagePipelineRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateImagePipelineRequest(")
        append("clientToken=$clientToken,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("description=$description,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imagePipelineArn=$imagePipelineArn,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("schedule=$schedule,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imagePipelineArn?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateImagePipelineRequest

        if (clientToken != other.clientToken) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (description != other.description) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imagePipelineArn != other.imagePipelineArn) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateImagePipelineRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateImagePipelineRequest
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the container pipeline to update.
         */
        fun containerRecipeArn(containerRecipeArn: String): FluentBuilder
        /**
         * The description of the image pipeline.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
         * configure and distribute images updated by this image pipeline.
         */
        fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that you want to update.
         */
        fun imagePipelineArn(imagePipelineArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
         * updated by this image pipeline.
         */
        fun imageRecipeArn(imageRecipeArn: String): FluentBuilder
        /**
         * The image test configuration of the image pipeline.
         */
        fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
         * build images updated by this image pipeline.
         */
        fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder
        /**
         * The schedule of the image pipeline.
         */
        fun schedule(schedule: Schedule): FluentBuilder
        /**
         * The status of the image pipeline.
         */
        fun status(status: PipelineStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The Amazon Resource Name (ARN) of the container pipeline to update.
         */
        var containerRecipeArn: String?
        /**
         * The description of the image pipeline.
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to
         * configure and distribute images updated by this image pipeline.
         */
        var distributionConfigurationArn: String?
        /**
         * Collects additional information about the image being created, including the operating
         * system (OS) version and package list. This information is used to enhance the overall
         * experience of using EC2 Image Builder. Enabled by default.
         */
        var enhancedImageMetadataEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the image pipeline that you want to update.
         */
        var imagePipelineArn: String?
        /**
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
         * updated by this image pipeline.
         */
        var imageRecipeArn: String?
        /**
         * The image test configuration of the image pipeline.
         */
        var imageTestsConfiguration: ImageTestsConfiguration?
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
         * build images updated by this image pipeline.
         */
        var infrastructureConfigurationArn: String?
        /**
         * The schedule of the image pipeline.
         */
        var schedule: Schedule?
        /**
         * The status of the image pipeline.
         */
        var status: PipelineStatus?

        fun build(): UpdateImagePipelineRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        fun imageTestsConfiguration(block: ImageTestsConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = ImageTestsConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Schedule] inside the given [block]
         */
        fun schedule(block: Schedule.DslBuilder.() -> kotlin.Unit) {
            this.schedule = Schedule.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var containerRecipeArn: String? = null
        override var description: String? = null
        override var distributionConfigurationArn: String? = null
        override var enhancedImageMetadataEnabled: Boolean? = null
        override var imagePipelineArn: String? = null
        override var imageRecipeArn: String? = null
        override var imageTestsConfiguration: ImageTestsConfiguration? = null
        override var infrastructureConfigurationArn: String? = null
        override var schedule: Schedule? = null
        override var status: PipelineStatus? = null

        constructor(x: UpdateImagePipelineRequest) : this() {
            this.clientToken = x.clientToken
            this.containerRecipeArn = x.containerRecipeArn
            this.description = x.description
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imagePipelineArn = x.imagePipelineArn
            this.imageRecipeArn = x.imageRecipeArn
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.schedule = x.schedule
            this.status = x.status
        }

        override fun build(): UpdateImagePipelineRequest = UpdateImagePipelineRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun containerRecipeArn(containerRecipeArn: String): FluentBuilder = apply { this.containerRecipeArn = containerRecipeArn }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun distributionConfigurationArn(distributionConfigurationArn: String): FluentBuilder = apply { this.distributionConfigurationArn = distributionConfigurationArn }
        override fun enhancedImageMetadataEnabled(enhancedImageMetadataEnabled: Boolean): FluentBuilder = apply { this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled }
        override fun imagePipelineArn(imagePipelineArn: String): FluentBuilder = apply { this.imagePipelineArn = imagePipelineArn }
        override fun imageRecipeArn(imageRecipeArn: String): FluentBuilder = apply { this.imageRecipeArn = imageRecipeArn }
        override fun imageTestsConfiguration(imageTestsConfiguration: ImageTestsConfiguration): FluentBuilder = apply { this.imageTestsConfiguration = imageTestsConfiguration }
        override fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder = apply { this.infrastructureConfigurationArn = infrastructureConfigurationArn }
        override fun schedule(schedule: Schedule): FluentBuilder = apply { this.schedule = schedule }
        override fun status(status: PipelineStatus): FluentBuilder = apply { this.status = status }
    }
}
