// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



class UpdateInfrastructureConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The idempotency token used to make this request idempotent.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The description of the infrastructure configuration.
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
     * update.
     */
    val infrastructureConfigurationArn: String? = builder.infrastructureConfigurationArn
    /**
     * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     */
    val instanceProfileName: String? = builder.instanceProfileName
    /**
     * The instance types of the infrastructure configuration. You can specify one or more
     * instance types to use for this build. The service will pick one of these instance types based
     * on availability.
     */
    val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The key pair of the infrastructure configuration. This can be used to log on to and debug
     * the instance used to create your image.
     */
    val keyPair: String? = builder.keyPair
    /**
     * The logging configuration of the infrastructure configuration.
     */
    val logging: Logging? = builder.logging
    /**
     * The tags attached to the resource created by Image Builder.
     */
    val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The SNS topic on which to send image build events.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The terminate instance on failure setting of the infrastructure configuration. Set to
     * false if you want Image Builder to retain the instance used to configure your AMI if the build
     * or test phase of your workflow fails.
     */
    val terminateInstanceOnFailure: Boolean? = builder.terminateInstanceOnFailure

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateInfrastructureConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInfrastructureConfigurationRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("instanceProfileName=$instanceProfileName,")
        append("instanceTypes=$instanceTypes,")
        append("keyPair=$keyPair,")
        append("logging=$logging,")
        append("resourceTags=$resourceTags,")
        append("securityGroupIds=$securityGroupIds,")
        append("snsTopicArn=$snsTopicArn,")
        append("subnetId=$subnetId,")
        append("terminateInstanceOnFailure=$terminateInstanceOnFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (terminateInstanceOnFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateInfrastructureConfigurationRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (instanceTypes != other.instanceTypes) return false
        if (keyPair != other.keyPair) return false
        if (logging != other.logging) return false
        if (resourceTags != other.resourceTags) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (subnetId != other.subnetId) return false
        if (terminateInstanceOnFailure != other.terminateInstanceOnFailure) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateInfrastructureConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateInfrastructureConfigurationRequest
        /**
         * The idempotency token used to make this request idempotent.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The description of the infrastructure configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
         * update.
         */
        fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder
        /**
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         */
        fun instanceProfileName(instanceProfileName: String): FluentBuilder
        /**
         * The instance types of the infrastructure configuration. You can specify one or more
         * instance types to use for this build. The service will pick one of these instance types based
         * on availability.
         */
        fun instanceTypes(instanceTypes: List<String>): FluentBuilder
        /**
         * The key pair of the infrastructure configuration. This can be used to log on to and debug
         * the instance used to create your image.
         */
        fun keyPair(keyPair: String): FluentBuilder
        /**
         * The logging configuration of the infrastructure configuration.
         */
        fun logging(logging: Logging): FluentBuilder
        /**
         * The tags attached to the resource created by Image Builder.
         */
        fun resourceTags(resourceTags: Map<String, String>): FluentBuilder
        /**
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The SNS topic on which to send image build events.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The terminate instance on failure setting of the infrastructure configuration. Set to
         * false if you want Image Builder to retain the instance used to configure your AMI if the build
         * or test phase of your workflow fails.
         */
        fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The idempotency token used to make this request idempotent.
         */
        var clientToken: String?
        /**
         * The description of the infrastructure configuration.
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
         * update.
         */
        var infrastructureConfigurationArn: String?
        /**
         * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
         */
        var instanceProfileName: String?
        /**
         * The instance types of the infrastructure configuration. You can specify one or more
         * instance types to use for this build. The service will pick one of these instance types based
         * on availability.
         */
        var instanceTypes: List<String>?
        /**
         * The key pair of the infrastructure configuration. This can be used to log on to and debug
         * the instance used to create your image.
         */
        var keyPair: String?
        /**
         * The logging configuration of the infrastructure configuration.
         */
        var logging: Logging?
        /**
         * The tags attached to the resource created by Image Builder.
         */
        var resourceTags: Map<String, String>?
        /**
         * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         */
        var securityGroupIds: List<String>?
        /**
         * The SNS topic on which to send image build events.
         */
        var snsTopicArn: String?
        /**
         * The subnet ID to place the instance used to customize your Amazon EC2 AMI in.
         */
        var subnetId: String?
        /**
         * The terminate instance on failure setting of the infrastructure configuration. Set to
         * false if you want Image Builder to retain the instance used to configure your AMI if the build
         * or test phase of your workflow fails.
         */
        var terminateInstanceOnFailure: Boolean?

        fun build(): UpdateInfrastructureConfigurationRequest
        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Logging] inside the given [block]
         */
        fun logging(block: Logging.DslBuilder.() -> kotlin.Unit) {
            this.logging = Logging.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var infrastructureConfigurationArn: String? = null
        override var instanceProfileName: String? = null
        override var instanceTypes: List<String>? = null
        override var keyPair: String? = null
        override var logging: Logging? = null
        override var resourceTags: Map<String, String>? = null
        override var securityGroupIds: List<String>? = null
        override var snsTopicArn: String? = null
        override var subnetId: String? = null
        override var terminateInstanceOnFailure: Boolean? = null

        constructor(x: UpdateInfrastructureConfigurationRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.instanceProfileName = x.instanceProfileName
            this.instanceTypes = x.instanceTypes
            this.keyPair = x.keyPair
            this.logging = x.logging
            this.resourceTags = x.resourceTags
            this.securityGroupIds = x.securityGroupIds
            this.snsTopicArn = x.snsTopicArn
            this.subnetId = x.subnetId
            this.terminateInstanceOnFailure = x.terminateInstanceOnFailure
        }

        override fun build(): UpdateInfrastructureConfigurationRequest = UpdateInfrastructureConfigurationRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun infrastructureConfigurationArn(infrastructureConfigurationArn: String): FluentBuilder = apply { this.infrastructureConfigurationArn = infrastructureConfigurationArn }
        override fun instanceProfileName(instanceProfileName: String): FluentBuilder = apply { this.instanceProfileName = instanceProfileName }
        override fun instanceTypes(instanceTypes: List<String>): FluentBuilder = apply { this.instanceTypes = instanceTypes }
        override fun keyPair(keyPair: String): FluentBuilder = apply { this.keyPair = keyPair }
        override fun logging(logging: Logging): FluentBuilder = apply { this.logging = logging }
        override fun resourceTags(resourceTags: Map<String, String>): FluentBuilder = apply { this.resourceTags = resourceTags }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun terminateInstanceOnFailure(terminateInstanceOnFailure: Boolean): FluentBuilder = apply { this.terminateInstanceOnFailure = terminateInstanceOnFailure }
    }
}
