// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.imagebuilder.model.ComponentSummary
import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListComponentBuildVersionsOperationDeserializer: HttpDeserialize<ListComponentBuildVersionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListComponentBuildVersionsResponse {
        if (!response.status.isSuccess()) {
            throwListComponentBuildVersionsError(context, response)
        }
        val builder = ListComponentBuildVersionsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListComponentBuildVersionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListComponentBuildVersionsOperationBody(builder: ListComponentBuildVersionsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTSUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("componentSummaryList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTSUMMARYLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTSUMMARYLIST_DESCRIPTOR.index -> builder.componentSummaryList =
                    deserializer.deserializeList(COMPONENTSUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ComponentSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeComponentSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListComponentBuildVersionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer()
        "ClientException" -> ClientExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ServiceException" -> ServiceExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        else -> throw ImagebuilderException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
