// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.inspector2.model.*
import aws.sdk.kotlin.services.inspector2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Inspector2"
public const val ServiceApiVersion: String = "2020-06-08"
public const val SdkVersion: String = "0.17.8-beta"

internal class DefaultInspector2Client(override val config: Inspector2Client.Config) : Inspector2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.
     */
    override suspend fun associateMember(input: AssociateMemberRequest): AssociateMemberResponse {
        val op = SdkHttpOperation.build<AssociateMemberRequest, AssociateMemberResponse> {
            serializer = AssociateMemberOperationSerializer()
            deserializer = AssociateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     */
    override suspend fun batchGetAccountStatus(input: BatchGetAccountStatusRequest): BatchGetAccountStatusResponse {
        val op = SdkHttpOperation.build<BatchGetAccountStatusRequest, BatchGetAccountStatusResponse> {
            serializer = BatchGetAccountStatusOperationSerializer()
            deserializer = BatchGetAccountStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetAccountStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets free trial status for multiple Amazon Web Services accounts.
     */
    override suspend fun batchGetFreeTrialInfo(input: BatchGetFreeTrialInfoRequest): BatchGetFreeTrialInfoResponse {
        val op = SdkHttpOperation.build<BatchGetFreeTrialInfoRequest, BatchGetFreeTrialInfoResponse> {
            serializer = BatchGetFreeTrialInfoOperationSerializer()
            deserializer = BatchGetFreeTrialInfoOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetFreeTrialInfo"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the given findings report.
     */
    override suspend fun cancelFindingsReport(input: CancelFindingsReportRequest): CancelFindingsReportResponse {
        val op = SdkHttpOperation.build<CancelFindingsReportRequest, CancelFindingsReportResponse> {
            serializer = CancelFindingsReportOperationSerializer()
            deserializer = CancelFindingsReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelFindingsReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a filter resource using specified filter criteria.
     */
    override suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse {
        val op = SdkHttpOperation.build<CreateFilterRequest, CreateFilterResponse> {
            serializer = CreateFilterOperationSerializer()
            deserializer = CreateFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a finding report.
     */
    override suspend fun createFindingsReport(input: CreateFindingsReportRequest): CreateFindingsReportResponse {
        val op = SdkHttpOperation.build<CreateFindingsReportRequest, CreateFindingsReportResponse> {
            serializer = CreateFindingsReportOperationSerializer()
            deserializer = CreateFindingsReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFindingsReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a filter resource.
     */
    override suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse {
        val op = SdkHttpOperation.build<DeleteFilterRequest, DeleteFilterResponse> {
            serializer = DeleteFilterOperationSerializer()
            deserializer = DeleteFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization
     */
    override suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse> {
            serializer = DescribeOrganizationConfigurationOperationSerializer()
            deserializer = DescribeOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
     */
    override suspend fun disable(input: DisableRequest): DisableResponse {
        val op = SdkHttpOperation.build<DisableRequest, DisableResponse> {
            serializer = DisableOperationSerializer()
            deserializer = DisableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Disable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the Amazon Inspector delegated administrator for your organization.
     */
    override suspend fun disableDelegatedAdminAccount(input: DisableDelegatedAdminAccountRequest): DisableDelegatedAdminAccountResponse {
        val op = SdkHttpOperation.build<DisableDelegatedAdminAccountRequest, DisableDelegatedAdminAccountResponse> {
            serializer = DisableDelegatedAdminAccountOperationSerializer()
            deserializer = DisableDelegatedAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableDelegatedAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     */
    override suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse {
        val op = SdkHttpOperation.build<DisassociateMemberRequest, DisassociateMemberResponse> {
            serializer = DisassociateMemberOperationSerializer()
            deserializer = DisassociateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     */
    override suspend fun enable(input: EnableRequest): EnableResponse {
        val op = SdkHttpOperation.build<EnableRequest, EnableResponse> {
            serializer = EnableOperationSerializer()
            deserializer = EnableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Enable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     */
    override suspend fun enableDelegatedAdminAccount(input: EnableDelegatedAdminAccountRequest): EnableDelegatedAdminAccountResponse {
        val op = SdkHttpOperation.build<EnableDelegatedAdminAccountRequest, EnableDelegatedAdminAccountResponse> {
            serializer = EnableDelegatedAdminAccountOperationSerializer()
            deserializer = EnableDelegatedAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableDelegatedAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves setting configurations for Inspector scans.
     */
    override suspend fun getConfiguration(input: GetConfigurationRequest): GetConfigurationResponse {
        val op = SdkHttpOperation.build<GetConfigurationRequest, GetConfigurationResponse> {
            serializer = GetConfigurationOperationSerializer()
            deserializer = GetConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     */
    override suspend fun getDelegatedAdminAccount(input: GetDelegatedAdminAccountRequest): GetDelegatedAdminAccountResponse {
        val op = SdkHttpOperation.build<GetDelegatedAdminAccountRequest, GetDelegatedAdminAccountResponse> {
            serializer = GetDelegatedAdminAccountOperationSerializer()
            deserializer = GetDelegatedAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDelegatedAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of a findings report.
     */
    override suspend fun getFindingsReportStatus(input: GetFindingsReportStatusRequest): GetFindingsReportStatusResponse {
        val op = SdkHttpOperation.build<GetFindingsReportStatusRequest, GetFindingsReportStatusResponse> {
            serializer = GetFindingsReportStatusOperationSerializer()
            deserializer = GetFindingsReportStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsReportStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets member information for your organization.
     */
    override suspend fun getMember(input: GetMemberRequest): GetMemberResponse {
        val op = SdkHttpOperation.build<GetMemberRequest, GetMemberResponse> {
            serializer = GetMemberOperationSerializer()
            deserializer = GetMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the permissions an account has to configure Amazon Inspector.
     */
    override suspend fun listAccountPermissions(input: ListAccountPermissionsRequest): ListAccountPermissionsResponse {
        val op = SdkHttpOperation.build<ListAccountPermissionsRequest, ListAccountPermissionsResponse> {
            serializer = ListAccountPermissionsOperationSerializer()
            deserializer = ListAccountPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists coverage details for you environment.
     */
    override suspend fun listCoverage(input: ListCoverageRequest): ListCoverageResponse {
        val op = SdkHttpOperation.build<ListCoverageRequest, ListCoverageResponse> {
            serializer = ListCoverageOperationSerializer()
            deserializer = ListCoverageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCoverage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon Inspector coverage statistics for your environment.
     */
    override suspend fun listCoverageStatistics(input: ListCoverageStatisticsRequest): ListCoverageStatisticsResponse {
        val op = SdkHttpOperation.build<ListCoverageStatisticsRequest, ListCoverageStatisticsResponse> {
            serializer = ListCoverageStatisticsOperationSerializer()
            deserializer = ListCoverageStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCoverageStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     */
    override suspend fun listDelegatedAdminAccounts(input: ListDelegatedAdminAccountsRequest): ListDelegatedAdminAccountsResponse {
        val op = SdkHttpOperation.build<ListDelegatedAdminAccountsRequest, ListDelegatedAdminAccountsResponse> {
            serializer = ListDelegatedAdminAccountsOperationSerializer()
            deserializer = ListDelegatedAdminAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDelegatedAdminAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the filters associated with your account.
     */
    override suspend fun listFilters(input: ListFiltersRequest): ListFiltersResponse {
        val op = SdkHttpOperation.build<ListFiltersRequest, ListFiltersResponse> {
            serializer = ListFiltersOperationSerializer()
            deserializer = ListFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFilters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists aggregated finding data for your environment based on specific criteria.
     */
    override suspend fun listFindingAggregations(input: ListFindingAggregationsRequest): ListFindingAggregationsResponse {
        val op = SdkHttpOperation.build<ListFindingAggregationsRequest, ListFindingAggregationsResponse> {
            serializer = ListFindingAggregationsOperationSerializer()
            deserializer = ListFindingAggregationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindingAggregations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists findings for your environment.
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializer = ListFindingsOperationSerializer()
            deserializer = ListFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags attached to a given resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Inspector usage totals over the last 30 days.
     */
    override suspend fun listUsageTotals(input: ListUsageTotalsRequest): ListUsageTotalsResponse {
        val op = SdkHttpOperation.build<ListUsageTotalsRequest, ListUsageTotalsResponse> {
            serializer = ListUsageTotalsOperationSerializer()
            deserializer = ListUsageTotalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsageTotals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
     */
    override suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationRequest, UpdateConfigurationResponse> {
            serializer = UpdateConfigurationOperationSerializer()
            deserializer = UpdateConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    override suspend fun updateFilter(input: UpdateFilterRequest): UpdateFilterResponse {
        val op = SdkHttpOperation.build<UpdateFilterRequest, UpdateFilterResponse> {
            serializer = UpdateFilterOperationSerializer()
            deserializer = UpdateFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configurations for your Amazon Inspector organization.
     */
    override suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse> {
            serializer = UpdateOrganizationConfigurationOperationSerializer()
            deserializer = UpdateOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "inspector2"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "inspector2")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
