// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.inspector2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.inspector2.model.*
import aws.sdk.kotlin.services.inspector2.model.AssociateMemberRequest
import aws.sdk.kotlin.services.inspector2.model.AssociateMemberResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetAccountStatusRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetAccountStatusResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetFreeTrialInfoRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetFreeTrialInfoResponse
import aws.sdk.kotlin.services.inspector2.model.CancelFindingsReportRequest
import aws.sdk.kotlin.services.inspector2.model.CancelFindingsReportResponse
import aws.sdk.kotlin.services.inspector2.model.CreateFilterRequest
import aws.sdk.kotlin.services.inspector2.model.CreateFilterResponse
import aws.sdk.kotlin.services.inspector2.model.CreateFindingsReportRequest
import aws.sdk.kotlin.services.inspector2.model.CreateFindingsReportResponse
import aws.sdk.kotlin.services.inspector2.model.DeleteFilterRequest
import aws.sdk.kotlin.services.inspector2.model.DeleteFilterResponse
import aws.sdk.kotlin.services.inspector2.model.DescribeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.DisableDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.DisableDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.DisableRequest
import aws.sdk.kotlin.services.inspector2.model.DisableResponse
import aws.sdk.kotlin.services.inspector2.model.DisassociateMemberRequest
import aws.sdk.kotlin.services.inspector2.model.DisassociateMemberResponse
import aws.sdk.kotlin.services.inspector2.model.EnableDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.EnableDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.EnableRequest
import aws.sdk.kotlin.services.inspector2.model.EnableResponse
import aws.sdk.kotlin.services.inspector2.model.GetConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.GetConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.GetDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.GetDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.GetFindingsReportStatusRequest
import aws.sdk.kotlin.services.inspector2.model.GetFindingsReportStatusResponse
import aws.sdk.kotlin.services.inspector2.model.GetMemberRequest
import aws.sdk.kotlin.services.inspector2.model.GetMemberResponse
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsRequest
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsResponse
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsRequest
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFiltersRequest
import aws.sdk.kotlin.services.inspector2.model.ListFiltersResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector2.model.ListMembersRequest
import aws.sdk.kotlin.services.inspector2.model.ListMembersResponse
import aws.sdk.kotlin.services.inspector2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.inspector2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsRequest
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsResponse
import aws.sdk.kotlin.services.inspector2.model.TagResourceRequest
import aws.sdk.kotlin.services.inspector2.model.TagResourceResponse
import aws.sdk.kotlin.services.inspector2.model.UntagResourceRequest
import aws.sdk.kotlin.services.inspector2.model.UntagResourceResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateFilterRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateFilterResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateOrganizationConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateOrganizationConfigurationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities within your Amazon EC2 and Amazon ECR environments.
 */
public interface Inspector2Client : SdkClient {

    override val serviceName: String
        get() = "Inspector2"
    /**
     * Inspector2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Inspector2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultInspector2Client(config)
        }

        public operator fun invoke(config: Config): Inspector2Client = DefaultInspector2Client(config)

        /**
         * Construct a [Inspector2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Inspector2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultInspector2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.
     */
    public suspend fun associateMember(input: AssociateMemberRequest): AssociateMemberResponse

    /**
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     */
    public suspend fun batchGetAccountStatus(input: BatchGetAccountStatusRequest = BatchGetAccountStatusRequest {}): BatchGetAccountStatusResponse

    /**
     * Gets free trial status for multiple Amazon Web Services accounts.
     */
    public suspend fun batchGetFreeTrialInfo(input: BatchGetFreeTrialInfoRequest): BatchGetFreeTrialInfoResponse

    /**
     * Cancels the given findings report.
     */
    public suspend fun cancelFindingsReport(input: CancelFindingsReportRequest): CancelFindingsReportResponse

    /**
     * Creates a filter resource using specified filter criteria.
     */
    public suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse

    /**
     * Creates a finding report.
     */
    public suspend fun createFindingsReport(input: CreateFindingsReportRequest): CreateFindingsReportResponse

    /**
     * Deletes a filter resource.
     */
    public suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse

    /**
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization
     */
    public suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest = DescribeOrganizationConfigurationRequest {}): DescribeOrganizationConfigurationResponse

    /**
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
     */
    public suspend fun disable(input: DisableRequest = DisableRequest {}): DisableResponse

    /**
     * Disables the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun disableDelegatedAdminAccount(input: DisableDelegatedAdminAccountRequest): DisableDelegatedAdminAccountResponse

    /**
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     */
    public suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse

    /**
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     */
    public suspend fun enable(input: EnableRequest): EnableResponse

    /**
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     */
    public suspend fun enableDelegatedAdminAccount(input: EnableDelegatedAdminAccountRequest): EnableDelegatedAdminAccountResponse

    /**
     * Retrieves setting configurations for Inspector scans.
     */
    public suspend fun getConfiguration(input: GetConfigurationRequest = GetConfigurationRequest {}): GetConfigurationResponse

    /**
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun getDelegatedAdminAccount(input: GetDelegatedAdminAccountRequest = GetDelegatedAdminAccountRequest {}): GetDelegatedAdminAccountResponse

    /**
     * Gets the status of a findings report.
     */
    public suspend fun getFindingsReportStatus(input: GetFindingsReportStatusRequest = GetFindingsReportStatusRequest {}): GetFindingsReportStatusResponse

    /**
     * Gets member information for your organization.
     */
    public suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Lists the permissions an account has to configure Amazon Inspector.
     */
    public suspend fun listAccountPermissions(input: ListAccountPermissionsRequest = ListAccountPermissionsRequest {}): ListAccountPermissionsResponse

    /**
     * Lists coverage details for you environment.
     */
    public suspend fun listCoverage(input: ListCoverageRequest = ListCoverageRequest {}): ListCoverageResponse

    /**
     * Lists Amazon Inspector coverage statistics for your environment.
     */
    public suspend fun listCoverageStatistics(input: ListCoverageStatisticsRequest = ListCoverageStatisticsRequest {}): ListCoverageStatisticsResponse

    /**
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     */
    public suspend fun listDelegatedAdminAccounts(input: ListDelegatedAdminAccountsRequest = ListDelegatedAdminAccountsRequest {}): ListDelegatedAdminAccountsResponse

    /**
     * Lists the filters associated with your account.
     */
    public suspend fun listFilters(input: ListFiltersRequest = ListFiltersRequest {}): ListFiltersResponse

    /**
     * Lists aggregated finding data for your environment based on specific criteria.
     */
    public suspend fun listFindingAggregations(input: ListFindingAggregationsRequest): ListFindingAggregationsResponse

    /**
     * Lists findings for your environment.
     */
    public suspend fun listFindings(input: ListFindingsRequest = ListFindingsRequest {}): ListFindingsResponse

    /**
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun listMembers(input: ListMembersRequest = ListMembersRequest {}): ListMembersResponse

    /**
     * Lists all tags attached to a given resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the Amazon Inspector usage totals over the last 30 days.
     */
    public suspend fun listUsageTotals(input: ListUsageTotalsRequest = ListUsageTotalsRequest {}): ListUsageTotalsResponse

    /**
     * Adds tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    public suspend fun updateFilter(input: UpdateFilterRequest): UpdateFilterResponse

    /**
     * Updates the configurations for your Amazon Inspector organization.
     */
    public suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse
}

/**
 * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.
 */
public suspend inline fun Inspector2Client.associateMember(crossinline block: AssociateMemberRequest.Builder.() -> Unit): AssociateMemberResponse = associateMember(AssociateMemberRequest.Builder().apply(block).build())

/**
 * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
 */
public suspend inline fun Inspector2Client.batchGetAccountStatus(crossinline block: BatchGetAccountStatusRequest.Builder.() -> Unit): BatchGetAccountStatusResponse = batchGetAccountStatus(BatchGetAccountStatusRequest.Builder().apply(block).build())

/**
 * Gets free trial status for multiple Amazon Web Services accounts.
 */
public suspend inline fun Inspector2Client.batchGetFreeTrialInfo(crossinline block: BatchGetFreeTrialInfoRequest.Builder.() -> Unit): BatchGetFreeTrialInfoResponse = batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest.Builder().apply(block).build())

/**
 * Cancels the given findings report.
 */
public suspend inline fun Inspector2Client.cancelFindingsReport(crossinline block: CancelFindingsReportRequest.Builder.() -> Unit): CancelFindingsReportResponse = cancelFindingsReport(CancelFindingsReportRequest.Builder().apply(block).build())

/**
 * Creates a filter resource using specified filter criteria.
 */
public suspend inline fun Inspector2Client.createFilter(crossinline block: CreateFilterRequest.Builder.() -> Unit): CreateFilterResponse = createFilter(CreateFilterRequest.Builder().apply(block).build())

/**
 * Creates a finding report.
 */
public suspend inline fun Inspector2Client.createFindingsReport(crossinline block: CreateFindingsReportRequest.Builder.() -> Unit): CreateFindingsReportResponse = createFindingsReport(CreateFindingsReportRequest.Builder().apply(block).build())

/**
 * Deletes a filter resource.
 */
public suspend inline fun Inspector2Client.deleteFilter(crossinline block: DeleteFilterRequest.Builder.() -> Unit): DeleteFilterResponse = deleteFilter(DeleteFilterRequest.Builder().apply(block).build())

/**
 * Describe Amazon Inspector configuration settings for an Amazon Web Services organization
 */
public suspend inline fun Inspector2Client.describeOrganizationConfiguration(crossinline block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit): DescribeOrganizationConfigurationResponse = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
 */
public suspend inline fun Inspector2Client.disable(crossinline block: DisableRequest.Builder.() -> Unit): DisableResponse = disable(DisableRequest.Builder().apply(block).build())

/**
 * Disables the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.disableDelegatedAdminAccount(crossinline block: DisableDelegatedAdminAccountRequest.Builder.() -> Unit): DisableDelegatedAdminAccountResponse = disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Disassociates a member account from an Amazon Inspector delegated administrator.
 */
public suspend inline fun Inspector2Client.disassociateMember(crossinline block: DisassociateMemberRequest.Builder.() -> Unit): DisassociateMemberResponse = disassociateMember(DisassociateMemberRequest.Builder().apply(block).build())

/**
 * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
 */
public suspend inline fun Inspector2Client.enable(crossinline block: EnableRequest.Builder.() -> Unit): EnableResponse = enable(EnableRequest.Builder().apply(block).build())

/**
 * Enables the Amazon Inspector delegated administrator for your Organizations organization.
 */
public suspend inline fun Inspector2Client.enableDelegatedAdminAccount(crossinline block: EnableDelegatedAdminAccountRequest.Builder.() -> Unit): EnableDelegatedAdminAccountResponse = enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Retrieves setting configurations for Inspector scans.
 */
public suspend inline fun Inspector2Client.getConfiguration(crossinline block: GetConfigurationRequest.Builder.() -> Unit): GetConfigurationResponse = getConfiguration(GetConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.getDelegatedAdminAccount(crossinline block: GetDelegatedAdminAccountRequest.Builder.() -> Unit): GetDelegatedAdminAccountResponse = getDelegatedAdminAccount(GetDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Gets the status of a findings report.
 */
public suspend inline fun Inspector2Client.getFindingsReportStatus(crossinline block: GetFindingsReportStatusRequest.Builder.() -> Unit): GetFindingsReportStatusResponse = getFindingsReportStatus(GetFindingsReportStatusRequest.Builder().apply(block).build())

/**
 * Gets member information for your organization.
 */
public suspend inline fun Inspector2Client.getMember(crossinline block: GetMemberRequest.Builder.() -> Unit): GetMemberResponse = getMember(GetMemberRequest.Builder().apply(block).build())

/**
 * Lists the permissions an account has to configure Amazon Inspector.
 */
public suspend inline fun Inspector2Client.listAccountPermissions(crossinline block: ListAccountPermissionsRequest.Builder.() -> Unit): ListAccountPermissionsResponse = listAccountPermissions(ListAccountPermissionsRequest.Builder().apply(block).build())

/**
 * Lists coverage details for you environment.
 */
public suspend inline fun Inspector2Client.listCoverage(crossinline block: ListCoverageRequest.Builder.() -> Unit): ListCoverageResponse = listCoverage(ListCoverageRequest.Builder().apply(block).build())

/**
 * Lists Amazon Inspector coverage statistics for your environment.
 */
public suspend inline fun Inspector2Client.listCoverageStatistics(crossinline block: ListCoverageStatisticsRequest.Builder.() -> Unit): ListCoverageStatisticsResponse = listCoverageStatistics(ListCoverageStatisticsRequest.Builder().apply(block).build())

/**
 * Lists information about the Amazon Inspector delegated administrator of your organization.
 */
public suspend inline fun Inspector2Client.listDelegatedAdminAccounts(crossinline block: ListDelegatedAdminAccountsRequest.Builder.() -> Unit): ListDelegatedAdminAccountsResponse = listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest.Builder().apply(block).build())

/**
 * Lists the filters associated with your account.
 */
public suspend inline fun Inspector2Client.listFilters(crossinline block: ListFiltersRequest.Builder.() -> Unit): ListFiltersResponse = listFilters(ListFiltersRequest.Builder().apply(block).build())

/**
 * Lists aggregated finding data for your environment based on specific criteria.
 */
public suspend inline fun Inspector2Client.listFindingAggregations(crossinline block: ListFindingAggregationsRequest.Builder.() -> Unit): ListFindingAggregationsResponse = listFindingAggregations(ListFindingAggregationsRequest.Builder().apply(block).build())

/**
 * Lists findings for your environment.
 */
public suspend inline fun Inspector2Client.listFindings(crossinline block: ListFindingsRequest.Builder.() -> Unit): ListFindingsResponse = listFindings(ListFindingsRequest.Builder().apply(block).build())

/**
 * List members associated with the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Lists all tags attached to a given resource.
 */
public suspend inline fun Inspector2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Inspector usage totals over the last 30 days.
 */
public suspend inline fun Inspector2Client.listUsageTotals(crossinline block: ListUsageTotalsRequest.Builder.() -> Unit): ListUsageTotalsResponse = listUsageTotals(ListUsageTotalsRequest.Builder().apply(block).build())

/**
 * Adds tags to a resource.
 */
public suspend inline fun Inspector2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource.
 */
public suspend inline fun Inspector2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
 */
public suspend inline fun Inspector2Client.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Specifies the action that is to be applied to the findings that match the filter.
 */
public suspend inline fun Inspector2Client.updateFilter(crossinline block: UpdateFilterRequest.Builder.() -> Unit): UpdateFilterResponse = updateFilter(UpdateFilterRequest.Builder().apply(block).build())

/**
 * Updates the configurations for your Amazon Inspector organization.
 */
public suspend inline fun Inspector2Client.updateOrganizationConfiguration(crossinline block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit): UpdateOrganizationConfigurationResponse = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())
