// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * A structure that identifies filter criteria for `GetCoverageStatistics`.
 */
public class CoverageFilterCriteria private constructor(builder: Builder) {
    /**
     * An array of Amazon Web Services account IDs to return coverage statistics for.
     */
    public val accountId: List<CoverageStringFilter>? = builder.accountId
    /**
     * The Amazon EC2 instance tags to filter on.
     */
    public val ec2InstanceTags: List<CoverageMapFilter>? = builder.ec2InstanceTags
    /**
     * The Amazon ECR image tags to filter on.
     */
    public val ecrImageTags: List<CoverageStringFilter>? = builder.ecrImageTags
    /**
     * The Amazon ECR repository name to filter on.
     */
    public val ecrRepositoryName: List<CoverageStringFilter>? = builder.ecrRepositoryName
    /**
     * An array of Amazon Web Services resource IDs to return coverage statistics for.
     */
    public val resourceId: List<CoverageStringFilter>? = builder.resourceId
    /**
     * An array of Amazon Web Services resource types to return coverage statistics for. The values can be `AWS_EC2_INSTANCE` or `AWS_ECR_REPOSITORY`.
     */
    public val resourceType: List<CoverageStringFilter>? = builder.resourceType
    /**
     * The scan status code to filter on.
     */
    public val scanStatusCode: List<CoverageStringFilter>? = builder.scanStatusCode
    /**
     * The scan status reason to filter on.
     */
    public val scanStatusReason: List<CoverageStringFilter>? = builder.scanStatusReason
    /**
     * An array of Amazon Inspector scan types to return coverage statistics for.
     */
    public val scanType: List<CoverageStringFilter>? = builder.scanType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoverageFilterCriteria(")
        append("accountId=$accountId,")
        append("ec2InstanceTags=$ec2InstanceTags,")
        append("ecrImageTags=$ecrImageTags,")
        append("ecrRepositoryName=$ecrRepositoryName,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("scanStatusCode=$scanStatusCode,")
        append("scanStatusReason=$scanStatusReason,")
        append("scanType=$scanType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceTags?.hashCode() ?: 0)
        result = 31 * result + (ecrImageTags?.hashCode() ?: 0)
        result = 31 * result + (ecrRepositoryName?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scanStatusCode?.hashCode() ?: 0)
        result = 31 * result + (scanStatusReason?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoverageFilterCriteria

        if (accountId != other.accountId) return false
        if (ec2InstanceTags != other.ec2InstanceTags) return false
        if (ecrImageTags != other.ecrImageTags) return false
        if (ecrRepositoryName != other.ecrRepositoryName) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (scanStatusCode != other.scanStatusCode) return false
        if (scanStatusReason != other.scanStatusReason) return false
        if (scanType != other.scanType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of Amazon Web Services account IDs to return coverage statistics for.
         */
        public var accountId: List<CoverageStringFilter>? = null
        /**
         * The Amazon EC2 instance tags to filter on.
         */
        public var ec2InstanceTags: List<CoverageMapFilter>? = null
        /**
         * The Amazon ECR image tags to filter on.
         */
        public var ecrImageTags: List<CoverageStringFilter>? = null
        /**
         * The Amazon ECR repository name to filter on.
         */
        public var ecrRepositoryName: List<CoverageStringFilter>? = null
        /**
         * An array of Amazon Web Services resource IDs to return coverage statistics for.
         */
        public var resourceId: List<CoverageStringFilter>? = null
        /**
         * An array of Amazon Web Services resource types to return coverage statistics for. The values can be `AWS_EC2_INSTANCE` or `AWS_ECR_REPOSITORY`.
         */
        public var resourceType: List<CoverageStringFilter>? = null
        /**
         * The scan status code to filter on.
         */
        public var scanStatusCode: List<CoverageStringFilter>? = null
        /**
         * The scan status reason to filter on.
         */
        public var scanStatusReason: List<CoverageStringFilter>? = null
        /**
         * An array of Amazon Inspector scan types to return coverage statistics for.
         */
        public var scanType: List<CoverageStringFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria) : this() {
            this.accountId = x.accountId
            this.ec2InstanceTags = x.ec2InstanceTags
            this.ecrImageTags = x.ecrImageTags
            this.ecrRepositoryName = x.ecrRepositoryName
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.scanStatusCode = x.scanStatusCode
            this.scanStatusReason = x.scanStatusReason
            this.scanType = x.scanType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = CoverageFilterCriteria(this)
    }
}
