// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * An object that contains details about a resource covered by Amazon Inspector.
 */
public class CoveredResource private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the covered resource.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The ID of the covered resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * An object that contains details about the metadata.
     */
    public val resourceMetadata: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata? = builder.resourceMetadata
    /**
     * The type of the covered resource.
     */
    public val resourceType: aws.sdk.kotlin.services.inspector2.model.CoverageResourceType? = builder.resourceType
    /**
     * The status of the scan covering the resource.
     */
    public val scanStatus: aws.sdk.kotlin.services.inspector2.model.ScanStatus? = builder.scanStatus
    /**
     * The Amazon Inspector scan type covering the resource.
     */
    public val scanType: aws.sdk.kotlin.services.inspector2.model.ScanType? = builder.scanType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CoveredResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoveredResource(")
        append("accountId=$accountId,")
        append("resourceId=$resourceId,")
        append("resourceMetadata=$resourceMetadata,")
        append("resourceType=$resourceType,")
        append("scanStatus=$scanStatus,")
        append("scanType=$scanType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scanStatus?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoveredResource

        if (accountId != other.accountId) return false
        if (resourceId != other.resourceId) return false
        if (resourceMetadata != other.resourceMetadata) return false
        if (resourceType != other.resourceType) return false
        if (scanStatus != other.scanStatus) return false
        if (scanType != other.scanType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CoveredResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the covered resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * The ID of the covered resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * An object that contains details about the metadata.
         */
        public var resourceMetadata: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata? = null
        /**
         * The type of the covered resource.
         */
        public var resourceType: aws.sdk.kotlin.services.inspector2.model.CoverageResourceType? = null
        /**
         * The status of the scan covering the resource.
         */
        public var scanStatus: aws.sdk.kotlin.services.inspector2.model.ScanStatus? = null
        /**
         * The Amazon Inspector scan type covering the resource.
         */
        public var scanType: aws.sdk.kotlin.services.inspector2.model.ScanType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CoveredResource) : this() {
            this.accountId = x.accountId
            this.resourceId = x.resourceId
            this.resourceMetadata = x.resourceMetadata
            this.resourceType = x.resourceType
            this.scanStatus = x.scanStatus
            this.scanType = x.scanType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CoveredResource = CoveredResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata] inside the given [block]
         */
        public fun resourceMetadata(block: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata.Builder.() -> kotlin.Unit) {
            this.resourceMetadata = aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ScanStatus] inside the given [block]
         */
        public fun scanStatus(block: aws.sdk.kotlin.services.inspector2.model.ScanStatus.Builder.() -> kotlin.Unit) {
            this.scanStatus = aws.sdk.kotlin.services.inspector2.model.ScanStatus.invoke(block)
        }
    }
}
