// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * The details that define an aggregation based on Amazon EC2 instances.
 */
public class Ec2InstanceAggregation private constructor(builder: Builder) {
    /**
     * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
     */
    public val amis: List<StringFilter>? = builder.amis
    /**
     * The Amazon EC2 instance IDs to aggregate findings for.
     */
    public val instanceIds: List<StringFilter>? = builder.instanceIds
    /**
     * The Amazon EC2 instance tags to aggregate findings for.
     */
    public val instanceTags: List<MapFilter>? = builder.instanceTags
    /**
     * The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are `ORACLE_LINUX_7` and `ALPINE_LINUX_3_8`.
     */
    public val operatingSystems: List<StringFilter>? = builder.operatingSystems
    /**
     * The value to sort results by.
     */
    public val sortBy: aws.sdk.kotlin.services.inspector2.model.Ec2InstanceSortBy? = builder.sortBy
    /**
     * The order to sort results by.
     */
    public val sortOrder: aws.sdk.kotlin.services.inspector2.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceAggregation(")
        append("amis=$amis,")
        append("instanceIds=$instanceIds,")
        append("instanceTags=$instanceTags,")
        append("operatingSystems=$operatingSystems,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amis?.hashCode() ?: 0
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (instanceTags?.hashCode() ?: 0)
        result = 31 * result + (operatingSystems?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceAggregation

        if (amis != other.amis) return false
        if (instanceIds != other.instanceIds) return false
        if (instanceTags != other.instanceTags) return false
        if (operatingSystems != other.operatingSystems) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         */
        public var amis: List<StringFilter>? = null
        /**
         * The Amazon EC2 instance IDs to aggregate findings for.
         */
        public var instanceIds: List<StringFilter>? = null
        /**
         * The Amazon EC2 instance tags to aggregate findings for.
         */
        public var instanceTags: List<MapFilter>? = null
        /**
         * The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are `ORACLE_LINUX_7` and `ALPINE_LINUX_3_8`.
         */
        public var operatingSystems: List<StringFilter>? = null
        /**
         * The value to sort results by.
         */
        public var sortBy: aws.sdk.kotlin.services.inspector2.model.Ec2InstanceSortBy? = null
        /**
         * The order to sort results by.
         */
        public var sortOrder: aws.sdk.kotlin.services.inspector2.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregation) : this() {
            this.amis = x.amis
            this.instanceIds = x.instanceIds
            this.instanceTags = x.instanceTags
            this.operatingSystems = x.operatingSystems
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregation = Ec2InstanceAggregation(this)
    }
}
