// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about an Amazon Inspector finding.
 */
public class Finding private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID associated with the finding.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Number (ARN) of the finding.
     */
    public val findingArn: kotlin.String? = builder.findingArn
    /**
     * The date and time that the finding was first observed.
     */
    public val firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.firstObservedAt
    /**
     * Details on whether a fix is available through a version update. This value can be `YES`, `NO`, or `PARTIAL`. A `PARTIAL` fix means that some, but not all, of the packages identified in the finding have fixes available through updated versions.
     */
    public val fixAvailable: aws.sdk.kotlin.services.inspector2.model.FixAvailable? = builder.fixAvailable
    /**
     * The Amazon Inspector score given to the finding.
     */
    public val inspectorScore: kotlin.Double? = builder.inspectorScore
    /**
     * An object that contains details of the Amazon Inspector score.
     */
    public val inspectorScoreDetails: aws.sdk.kotlin.services.inspector2.model.InspectorScoreDetails? = builder.inspectorScoreDetails
    /**
     * The date and time that the finding was last observed.
     */
    public val lastObservedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastObservedAt
    /**
     * An object that contains the details of a network reachability finding.
     */
    public val networkReachabilityDetails: aws.sdk.kotlin.services.inspector2.model.NetworkReachabilityDetails? = builder.networkReachabilityDetails
    /**
     * An object that contains the details of a package vulnerability finding.
     */
    public val packageVulnerabilityDetails: aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails? = builder.packageVulnerabilityDetails
    /**
     * An object that contains the details about how to remediate a finding.
     */
    public val remediation: aws.sdk.kotlin.services.inspector2.model.Remediation? = builder.remediation
    /**
     * Contains information on the resources involved in a finding.
     */
    public val resources: List<Resource>? = builder.resources
    /**
     * The severity of the finding.
     */
    public val severity: aws.sdk.kotlin.services.inspector2.model.Severity? = builder.severity
    /**
     * The status of the finding.
     */
    public val status: aws.sdk.kotlin.services.inspector2.model.FindingStatus? = builder.status
    /**
     * The title of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The type of the finding.
     */
    public val type: aws.sdk.kotlin.services.inspector2.model.FindingType? = builder.type
    /**
     * The date and time the finding was last updated at.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.Finding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("awsAccountId=$awsAccountId,")
        append("description=$description,")
        append("findingArn=$findingArn,")
        append("firstObservedAt=$firstObservedAt,")
        append("fixAvailable=$fixAvailable,")
        append("inspectorScore=$inspectorScore,")
        append("inspectorScoreDetails=$inspectorScoreDetails,")
        append("lastObservedAt=$lastObservedAt,")
        append("networkReachabilityDetails=$networkReachabilityDetails,")
        append("packageVulnerabilityDetails=$packageVulnerabilityDetails,")
        append("remediation=$remediation,")
        append("resources=$resources,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingArn?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (fixAvailable?.hashCode() ?: 0)
        result = 31 * result + (inspectorScore?.hashCode() ?: 0)
        result = 31 * result + (inspectorScoreDetails?.hashCode() ?: 0)
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (networkReachabilityDetails?.hashCode() ?: 0)
        result = 31 * result + (packageVulnerabilityDetails?.hashCode() ?: 0)
        result = 31 * result + (remediation?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Finding

        if (awsAccountId != other.awsAccountId) return false
        if (description != other.description) return false
        if (findingArn != other.findingArn) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (fixAvailable != other.fixAvailable) return false
        if (inspectorScore != other.inspectorScore) return false
        if (inspectorScoreDetails != other.inspectorScoreDetails) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (networkReachabilityDetails != other.networkReachabilityDetails) return false
        if (packageVulnerabilityDetails != other.packageVulnerabilityDetails) return false
        if (remediation != other.remediation) return false
        if (resources != other.resources) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.Finding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID associated with the finding.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the finding.
         */
        public var findingArn: kotlin.String? = null
        /**
         * The date and time that the finding was first observed.
         */
        public var firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details on whether a fix is available through a version update. This value can be `YES`, `NO`, or `PARTIAL`. A `PARTIAL` fix means that some, but not all, of the packages identified in the finding have fixes available through updated versions.
         */
        public var fixAvailable: aws.sdk.kotlin.services.inspector2.model.FixAvailable? = null
        /**
         * The Amazon Inspector score given to the finding.
         */
        public var inspectorScore: kotlin.Double? = null
        /**
         * An object that contains details of the Amazon Inspector score.
         */
        public var inspectorScoreDetails: aws.sdk.kotlin.services.inspector2.model.InspectorScoreDetails? = null
        /**
         * The date and time that the finding was last observed.
         */
        public var lastObservedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that contains the details of a network reachability finding.
         */
        public var networkReachabilityDetails: aws.sdk.kotlin.services.inspector2.model.NetworkReachabilityDetails? = null
        /**
         * An object that contains the details of a package vulnerability finding.
         */
        public var packageVulnerabilityDetails: aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails? = null
        /**
         * An object that contains the details about how to remediate a finding.
         */
        public var remediation: aws.sdk.kotlin.services.inspector2.model.Remediation? = null
        /**
         * Contains information on the resources involved in a finding.
         */
        public var resources: List<Resource>? = null
        /**
         * The severity of the finding.
         */
        public var severity: aws.sdk.kotlin.services.inspector2.model.Severity? = null
        /**
         * The status of the finding.
         */
        public var status: aws.sdk.kotlin.services.inspector2.model.FindingStatus? = null
        /**
         * The title of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the finding.
         */
        public var type: aws.sdk.kotlin.services.inspector2.model.FindingType? = null
        /**
         * The date and time the finding was last updated at.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.Finding) : this() {
            this.awsAccountId = x.awsAccountId
            this.description = x.description
            this.findingArn = x.findingArn
            this.firstObservedAt = x.firstObservedAt
            this.fixAvailable = x.fixAvailable
            this.inspectorScore = x.inspectorScore
            this.inspectorScoreDetails = x.inspectorScoreDetails
            this.lastObservedAt = x.lastObservedAt
            this.networkReachabilityDetails = x.networkReachabilityDetails
            this.packageVulnerabilityDetails = x.packageVulnerabilityDetails
            this.remediation = x.remediation
            this.resources = x.resources
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.Finding = Finding(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.InspectorScoreDetails] inside the given [block]
         */
        public fun inspectorScoreDetails(block: aws.sdk.kotlin.services.inspector2.model.InspectorScoreDetails.Builder.() -> kotlin.Unit) {
            this.inspectorScoreDetails = aws.sdk.kotlin.services.inspector2.model.InspectorScoreDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.NetworkReachabilityDetails] inside the given [block]
         */
        public fun networkReachabilityDetails(block: aws.sdk.kotlin.services.inspector2.model.NetworkReachabilityDetails.Builder.() -> kotlin.Unit) {
            this.networkReachabilityDetails = aws.sdk.kotlin.services.inspector2.model.NetworkReachabilityDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails] inside the given [block]
         */
        public fun packageVulnerabilityDetails(block: aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails.Builder.() -> kotlin.Unit) {
            this.packageVulnerabilityDetails = aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.Remediation] inside the given [block]
         */
        public fun remediation(block: aws.sdk.kotlin.services.inspector2.model.Remediation.Builder.() -> kotlin.Unit) {
            this.remediation = aws.sdk.kotlin.services.inspector2.model.Remediation.invoke(block)
        }
    }
}
