// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.inspector2.model.AggregationResponse
import aws.sdk.kotlin.services.inspector2.model.AggregationType
import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListFindingAggregationsOperationDeserializer: HttpDeserialize<ListFindingAggregationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListFindingAggregationsResponse {
        if (!response.status.isSuccess()) {
            throwListFindingAggregationsError(context, response)
        }
        val builder = ListFindingAggregationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListFindingAggregationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListFindingAggregationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListFindingAggregationsOperationBody(builder: ListFindingAggregationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("aggregationType"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("responses"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATIONTYPE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESPONSES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGGREGATIONTYPE_DESCRIPTOR.index -> builder.aggregationType = deserializeString().let { AggregationType.fromValue(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESPONSES_DESCRIPTOR.index -> builder.responses =
                    deserializer.deserializeList(RESPONSES_DESCRIPTOR) {
                        val col0 = mutableListOf<AggregationResponse>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAggregationResponseDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
