// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The criteria by which the behavior is determined to be normal.
 */
class BehaviorCriteria private constructor(builder: Builder) {
    /**
     * The operator that relates the thing measured (metric) to the criteria
     * (containing a value or statisticalThreshold). Valid operators include:
     * string-list: in-set and not-in-set
     * number-list: in-set and not-in-set
     * ip-address-list: in-cidr-set and not-in-cidr-set
     * number: less-than, less-than-equals, greater-than, and greater-than-equals
     */
    val comparisonOperator: aws.sdk.kotlin.services.iot.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * If a device is in violation of the behavior for the specified number of consecutive
     * datapoints, an alarm occurs. If not specified, the default is 1.
     */
    val consecutiveDatapointsToAlarm: kotlin.Int? = builder.consecutiveDatapointsToAlarm
    /**
     * If an alarm has occurred and the offending device is no longer in violation of the behavior
     * for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
     * the default is 1.
     */
    val consecutiveDatapointsToClear: kotlin.Int? = builder.consecutiveDatapointsToClear
    /**
     * Use this to specify the time duration over which the behavior is evaluated, for those criteria that
     * have a time dimension (for example, NUM_MESSAGES_SENT). For a
     * statisticalThreshhold metric comparison, measurements from all devices are
     * accumulated over this time duration before being used to calculate percentiles, and later,
     * measurements from an individual device are also accumulated over this time duration before
     * being given a percentile rank. Cannot be used with list-based metric datatypes.
     */
    val durationSeconds: kotlin.Int? = builder.durationSeconds
    /**
     * The configuration of an ML Detect
     */
    val mlDetectionConfig: aws.sdk.kotlin.services.iot.model.MachineLearningDetectionConfig? = builder.mlDetectionConfig
    /**
     * A statistical ranking (percentile)that
     * indicates a threshold value by which a behavior is determined to be in compliance or in
     * violation of the behavior.
     */
    val statisticalThreshold: aws.sdk.kotlin.services.iot.model.StatisticalThreshold? = builder.statisticalThreshold
    /**
     * The value to be compared with the metric.
     */
    val value: aws.sdk.kotlin.services.iot.model.MetricValue? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.BehaviorCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BehaviorCriteria(")
        append("comparisonOperator=$comparisonOperator,")
        append("consecutiveDatapointsToAlarm=$consecutiveDatapointsToAlarm,")
        append("consecutiveDatapointsToClear=$consecutiveDatapointsToClear,")
        append("durationSeconds=$durationSeconds,")
        append("mlDetectionConfig=$mlDetectionConfig,")
        append("statisticalThreshold=$statisticalThreshold,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (consecutiveDatapointsToAlarm ?: 0)
        result = 31 * result + (consecutiveDatapointsToClear ?: 0)
        result = 31 * result + (durationSeconds ?: 0)
        result = 31 * result + (mlDetectionConfig?.hashCode() ?: 0)
        result = 31 * result + (statisticalThreshold?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BehaviorCriteria

        if (comparisonOperator != other.comparisonOperator) return false
        if (consecutiveDatapointsToAlarm != other.consecutiveDatapointsToAlarm) return false
        if (consecutiveDatapointsToClear != other.consecutiveDatapointsToClear) return false
        if (durationSeconds != other.durationSeconds) return false
        if (mlDetectionConfig != other.mlDetectionConfig) return false
        if (statisticalThreshold != other.statisticalThreshold) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.BehaviorCriteria = Builder(this).apply(block).build()

    class Builder {
        /**
         * The operator that relates the thing measured (metric) to the criteria
         * (containing a value or statisticalThreshold). Valid operators include:
         * string-list: in-set and not-in-set
         * number-list: in-set and not-in-set
         * ip-address-list: in-cidr-set and not-in-cidr-set
         * number: less-than, less-than-equals, greater-than, and greater-than-equals
         */
        var comparisonOperator: aws.sdk.kotlin.services.iot.model.ComparisonOperator? = null
        /**
         * If a device is in violation of the behavior for the specified number of consecutive
         * datapoints, an alarm occurs. If not specified, the default is 1.
         */
        var consecutiveDatapointsToAlarm: kotlin.Int? = null
        /**
         * If an alarm has occurred and the offending device is no longer in violation of the behavior
         * for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
         * the default is 1.
         */
        var consecutiveDatapointsToClear: kotlin.Int? = null
        /**
         * Use this to specify the time duration over which the behavior is evaluated, for those criteria that
         * have a time dimension (for example, NUM_MESSAGES_SENT). For a
         * statisticalThreshhold metric comparison, measurements from all devices are
         * accumulated over this time duration before being used to calculate percentiles, and later,
         * measurements from an individual device are also accumulated over this time duration before
         * being given a percentile rank. Cannot be used with list-based metric datatypes.
         */
        var durationSeconds: kotlin.Int? = null
        /**
         * The configuration of an ML Detect
         */
        var mlDetectionConfig: aws.sdk.kotlin.services.iot.model.MachineLearningDetectionConfig? = null
        /**
         * A statistical ranking (percentile)that
         * indicates a threshold value by which a behavior is determined to be in compliance or in
         * violation of the behavior.
         */
        var statisticalThreshold: aws.sdk.kotlin.services.iot.model.StatisticalThreshold? = null
        /**
         * The value to be compared with the metric.
         */
        var value: aws.sdk.kotlin.services.iot.model.MetricValue? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.BehaviorCriteria) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.consecutiveDatapointsToAlarm = x.consecutiveDatapointsToAlarm
            this.consecutiveDatapointsToClear = x.consecutiveDatapointsToClear
            this.durationSeconds = x.durationSeconds
            this.mlDetectionConfig = x.mlDetectionConfig
            this.statisticalThreshold = x.statisticalThreshold
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.BehaviorCriteria = BehaviorCriteria(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.MachineLearningDetectionConfig] inside the given [block]
         */
        fun mlDetectionConfig(block: aws.sdk.kotlin.services.iot.model.MachineLearningDetectionConfig.Builder.() -> kotlin.Unit) {
            this.mlDetectionConfig = aws.sdk.kotlin.services.iot.model.MachineLearningDetectionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.StatisticalThreshold] inside the given [block]
         */
        fun statisticalThreshold(block: aws.sdk.kotlin.services.iot.model.StatisticalThreshold.Builder.() -> kotlin.Unit) {
            this.statisticalThreshold = aws.sdk.kotlin.services.iot.model.StatisticalThreshold.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.MetricValue] inside the given [block]
         */
        fun value(block: aws.sdk.kotlin.services.iot.model.MetricValue.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.iot.model.MetricValue.invoke(block)
        }
    }
}
