// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CancelJobExecutionRequest private constructor(builder: Builder) {
    /**
     * (Optional) The expected current version of the job execution. Each time you update the job
     * execution, its version is incremented. If the version of the job execution stored in Jobs does
     * not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that
     * contains the current job execution status data is returned. (This makes it unnecessary to
     * perform a separate DescribeJobExecution request in order to obtain the job execution status
     * data.)
     */
    val expectedVersion: kotlin.Long? = builder.expectedVersion
    /**
     * (Optional) If true the job execution will be canceled if it has status
     * IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status
     * QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set
     * force to true, then an InvalidStateTransitionException
     * will be thrown. The default is false.
     * Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable
     * to update the job execution status.  Use caution and ensure that the device is able to
     * recover to a valid state.
     */
    val force: kotlin.Boolean = builder.force
    /**
     * The ID of the job to be canceled.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * A collection of name/value pairs that describe the status of the job execution. If not
     * specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.
     */
    val statusDetails: Map<String, String>? = builder.statusDetails
    /**
     * The name of the thing whose execution of the job will be canceled.
     */
    val thingName: kotlin.String? = builder.thingName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancelJobExecutionRequest(")
        append("expectedVersion=$expectedVersion,")
        append("force=$force,")
        append("jobId=$jobId,")
        append("statusDetails=$statusDetails,")
        append("thingName=$thingName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expectedVersion?.hashCode() ?: 0
        result = 31 * result + (force.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (thingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancelJobExecutionRequest

        if (expectedVersion != other.expectedVersion) return false
        if (force != other.force) return false
        if (jobId != other.jobId) return false
        if (statusDetails != other.statusDetails) return false
        if (thingName != other.thingName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) The expected current version of the job execution. Each time you update the job
         * execution, its version is incremented. If the version of the job execution stored in Jobs does
         * not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that
         * contains the current job execution status data is returned. (This makes it unnecessary to
         * perform a separate DescribeJobExecution request in order to obtain the job execution status
         * data.)
         */
        var expectedVersion: kotlin.Long? = null
        /**
         * (Optional) If true the job execution will be canceled if it has status
         * IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status
         * QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set
         * force to true, then an InvalidStateTransitionException
         * will be thrown. The default is false.
         * Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable
         * to update the job execution status.  Use caution and ensure that the device is able to
         * recover to a valid state.
         */
        var force: kotlin.Boolean = false
        /**
         * The ID of the job to be canceled.
         */
        var jobId: kotlin.String? = null
        /**
         * A collection of name/value pairs that describe the status of the job execution. If not
         * specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.
         */
        var statusDetails: Map<String, String>? = null
        /**
         * The name of the thing whose execution of the job will be canceled.
         */
        var thingName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest) : this() {
            this.expectedVersion = x.expectedVersion
            this.force = x.force
            this.jobId = x.jobId
            this.statusDetails = x.statusDetails
            this.thingName = x.thingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CancelJobExecutionRequest = CancelJobExecutionRequest(this)
    }
}
