// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CreateJobTemplateRequest private constructor(builder: Builder) {
    /**
     * The criteria that determine when and how a job abort takes place.
     */
    val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * A description of the job document.
     */
    val description: kotlin.String? = builder.description
    /**
     * The job document. Required if you don't specify a value for documentSource.
     */
    val document: kotlin.String? = builder.document
    /**
     * An S3 link to the job document to use in the template. Required if you don't specify a value for document.
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * The placeholder link is of the following form:
     * ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
     * where bucket is your bucket name and key is the object in the bucket to which you are linking.
     */
    val documentSource: kotlin.String? = builder.documentSource
    /**
     * The ARN of the job to use as the basis for the job template.
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * Allows you to create the criteria to retry a job.
     */
    val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of a job.
     */
    val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric
     * characters, "-", and "_" are valid for use here.
     */
    val jobTemplateId: kotlin.String? = builder.jobTemplateId
    /**
     * Configuration for pre-signed S3 URLs.
     */
    val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * Metadata that can be used to manage the job template.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specifies the amount of time each device has to finish its execution of the job.  A timer
     * is started when the job execution status is set to IN_PROGRESS. If the job
     * execution status is not set to another terminal state before the timer expires, it will
     * be automatically set to TIMED_OUT.
     */
    val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobTemplateRequest(")
        append("abortConfig=$abortConfig,")
        append("description=$description,")
        append("document=$document,")
        append("documentSource=$documentSource,")
        append("jobArn=$jobArn,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobTemplateId=$jobTemplateId,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("tags=$tags,")
        append("timeoutConfig=$timeoutConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (documentSource?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateId?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobTemplateRequest

        if (abortConfig != other.abortConfig) return false
        if (description != other.description) return false
        if (document != other.document) return false
        if (documentSource != other.documentSource) return false
        if (jobArn != other.jobArn) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobTemplateId != other.jobTemplateId) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (tags != other.tags) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The criteria that determine when and how a job abort takes place.
         */
        var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * A description of the job document.
         */
        var description: kotlin.String? = null
        /**
         * The job document. Required if you don't specify a value for documentSource.
         */
        var document: kotlin.String? = null
        /**
         * An S3 link to the job document to use in the template. Required if you don't specify a value for document.
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         * The placeholder link is of the following form:
         * ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
         * where bucket is your bucket name and key is the object in the bucket to which you are linking.
         */
        var documentSource: kotlin.String? = null
        /**
         * The ARN of the job to use as the basis for the job template.
         */
        var jobArn: kotlin.String? = null
        /**
         * Allows you to create the criteria to retry a job.
         */
        var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of a job.
         */
        var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric
         * characters, "-", and "_" are valid for use here.
         */
        var jobTemplateId: kotlin.String? = null
        /**
         * Configuration for pre-signed S3 URLs.
         */
        var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * Metadata that can be used to manage the job template.
         */
        var tags: List<Tag>? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job.  A timer
         * is started when the job execution status is set to IN_PROGRESS. If the job
         * execution status is not set to another terminal state before the timer expires, it will
         * be automatically set to TIMED_OUT.
         */
        var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest) : this() {
            this.abortConfig = x.abortConfig
            this.description = x.description
            this.document = x.document
            this.documentSource = x.documentSource
            this.jobArn = x.jobArn
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobTemplateId = x.jobTemplateId
            this.presignedUrlConfig = x.presignedUrlConfig
            this.tags = x.tags
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest = CreateJobTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }
    }
}
