// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The job process details.
 */
class JobProcessDetails private constructor(builder: Builder) {
    /**
     * The number of things that cancelled the job.
     */
    val numberOfCanceledThings: kotlin.Int? = builder.numberOfCanceledThings
    /**
     * The number of things that failed executing the job.
     */
    val numberOfFailedThings: kotlin.Int? = builder.numberOfFailedThings
    /**
     * The number of things currently executing the job.
     */
    val numberOfInProgressThings: kotlin.Int? = builder.numberOfInProgressThings
    /**
     * The number of things that are awaiting execution of the job.
     */
    val numberOfQueuedThings: kotlin.Int? = builder.numberOfQueuedThings
    /**
     * The number of things that rejected the job.
     */
    val numberOfRejectedThings: kotlin.Int? = builder.numberOfRejectedThings
    /**
     * The number of things that are no longer scheduled to execute the job because they have been deleted or
     * have been removed from the group that was a target of the job.
     */
    val numberOfRemovedThings: kotlin.Int? = builder.numberOfRemovedThings
    /**
     * The number of things which successfully completed the job.
     */
    val numberOfSucceededThings: kotlin.Int? = builder.numberOfSucceededThings
    /**
     * The number of things whose job execution status is TIMED_OUT.
     */
    val numberOfTimedOutThings: kotlin.Int? = builder.numberOfTimedOutThings
    /**
     * The target devices to which the job execution is being rolled out. This value will be null after the job execution has finished rolling out to all the target devices.
     */
    val processingTargets: List<String>? = builder.processingTargets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.JobProcessDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobProcessDetails(")
        append("numberOfCanceledThings=$numberOfCanceledThings,")
        append("numberOfFailedThings=$numberOfFailedThings,")
        append("numberOfInProgressThings=$numberOfInProgressThings,")
        append("numberOfQueuedThings=$numberOfQueuedThings,")
        append("numberOfRejectedThings=$numberOfRejectedThings,")
        append("numberOfRemovedThings=$numberOfRemovedThings,")
        append("numberOfSucceededThings=$numberOfSucceededThings,")
        append("numberOfTimedOutThings=$numberOfTimedOutThings,")
        append("processingTargets=$processingTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = numberOfCanceledThings ?: 0
        result = 31 * result + (numberOfFailedThings ?: 0)
        result = 31 * result + (numberOfInProgressThings ?: 0)
        result = 31 * result + (numberOfQueuedThings ?: 0)
        result = 31 * result + (numberOfRejectedThings ?: 0)
        result = 31 * result + (numberOfRemovedThings ?: 0)
        result = 31 * result + (numberOfSucceededThings ?: 0)
        result = 31 * result + (numberOfTimedOutThings ?: 0)
        result = 31 * result + (processingTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobProcessDetails

        if (numberOfCanceledThings != other.numberOfCanceledThings) return false
        if (numberOfFailedThings != other.numberOfFailedThings) return false
        if (numberOfInProgressThings != other.numberOfInProgressThings) return false
        if (numberOfQueuedThings != other.numberOfQueuedThings) return false
        if (numberOfRejectedThings != other.numberOfRejectedThings) return false
        if (numberOfRemovedThings != other.numberOfRemovedThings) return false
        if (numberOfSucceededThings != other.numberOfSucceededThings) return false
        if (numberOfTimedOutThings != other.numberOfTimedOutThings) return false
        if (processingTargets != other.processingTargets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.JobProcessDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of things that cancelled the job.
         */
        var numberOfCanceledThings: kotlin.Int? = null
        /**
         * The number of things that failed executing the job.
         */
        var numberOfFailedThings: kotlin.Int? = null
        /**
         * The number of things currently executing the job.
         */
        var numberOfInProgressThings: kotlin.Int? = null
        /**
         * The number of things that are awaiting execution of the job.
         */
        var numberOfQueuedThings: kotlin.Int? = null
        /**
         * The number of things that rejected the job.
         */
        var numberOfRejectedThings: kotlin.Int? = null
        /**
         * The number of things that are no longer scheduled to execute the job because they have been deleted or
         * have been removed from the group that was a target of the job.
         */
        var numberOfRemovedThings: kotlin.Int? = null
        /**
         * The number of things which successfully completed the job.
         */
        var numberOfSucceededThings: kotlin.Int? = null
        /**
         * The number of things whose job execution status is TIMED_OUT.
         */
        var numberOfTimedOutThings: kotlin.Int? = null
        /**
         * The target devices to which the job execution is being rolled out. This value will be null after the job execution has finished rolling out to all the target devices.
         */
        var processingTargets: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.JobProcessDetails) : this() {
            this.numberOfCanceledThings = x.numberOfCanceledThings
            this.numberOfFailedThings = x.numberOfFailedThings
            this.numberOfInProgressThings = x.numberOfInProgressThings
            this.numberOfQueuedThings = x.numberOfQueuedThings
            this.numberOfRejectedThings = x.numberOfRejectedThings
            this.numberOfRemovedThings = x.numberOfRemovedThings
            this.numberOfSucceededThings = x.numberOfSucceededThings
            this.numberOfTimedOutThings = x.numberOfTimedOutThings
            this.processingTargets = x.processingTargets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.JobProcessDetails = JobProcessDetails(this)
    }
}
