// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action to write data to an Amazon S3 bucket.
 */
class S3Action private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * The Amazon S3 canned ACL that controls access to the object identified by the object
     * key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs.
     */
    val cannedAcl: aws.sdk.kotlin.services.iot.model.CannedAccessControlList? = builder.cannedAcl
    /**
     * The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3.
     */
    val key: kotlin.String? = builder.key
    /**
     * The ARN of the IAM role that grants access.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.S3Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Action(")
        append("bucketName=$bucketName,")
        append("cannedAcl=$cannedAcl,")
        append("key=$key,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (cannedAcl?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Action

        if (bucketName != other.bucketName) return false
        if (cannedAcl != other.cannedAcl) return false
        if (key != other.key) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.S3Action = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon S3 bucket.
         */
        var bucketName: kotlin.String? = null
        /**
         * The Amazon S3 canned ACL that controls access to the object identified by the object
         * key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs.
         */
        var cannedAcl: aws.sdk.kotlin.services.iot.model.CannedAccessControlList? = null
        /**
         * The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3.
         */
        var key: kotlin.String? = null
        /**
         * The ARN of the IAM role that grants access.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.S3Action) : this() {
            this.bucketName = x.bucketName
            this.cannedAcl = x.cannedAcl
            this.key = x.key
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.S3Action = S3Action(this)
    }
}
